/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import java.io.InputStream;

public class ConfiguracoesUtil {
    public static ConfiguracoesCte iniciaConfiguracoes(ConfiguracoesCte configuracoesCte) throws CteException {
        return ConfiguracoesUtil.iniciaConfiguracoes(configuracoesCte, null);
    }

    public static ConfiguracoesCte iniciaConfiguracoes(ConfiguracoesCte configuracoesCte, String cpfCnpj) throws CteException {
        ObjetoCTeUtil.verifica(configuracoesCte).orElseThrow(() -> new CteException("Configura\u00e7\u00f5es n\u00e3o foram criadas"));
        try {
            if (!configuracoesCte.getCertificado().isValido()) {
                throw new CertificadoException("Certificado vencido ou inv\u00e1lido.");
            }
            if (configuracoesCte.isValidacaoDocumento() && cpfCnpj != null && !configuracoesCte.getCertificado().getCnpjCpf().substring(0, 8).equals(cpfCnpj.substring(0, 8))) {
                throw new CertificadoException("Documento do Certificado(" + configuracoesCte.getCertificado().getCnpjCpf() + ") n\u00e3o equivale ao Documento do Emissor(" + cpfCnpj + ")");
            }
            if (ObjetoCTeUtil.verifica(configuracoesCte.getCacert()).isPresent()) {
                CertificadoService.inicializaCertificado((Certificado)configuracoesCte.getCertificado(), (InputStream)configuracoesCte.getCacert());
            } else {
                CertificadoService.inicializaCertificado((Certificado)configuracoesCte.getCertificado());
            }
        }
        catch (CertificadoException e) {
            throw new CteException(e.getMessage());
        }
        return configuracoesCte;
    }
}

