/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.consReciCTe.TConsReciCTe;
import br.com.swconsultoria.cte.schema_300.consSitCTe.ObjectFactory;
import br.com.swconsultoria.cte.schema_300.consSitCTe.TConsSitCTe;
import br.com.swconsultoria.cte.schema_300.consStatServCTe.TConsStatServ;
import br.com.swconsultoria.cte.schema_300.cteModalRodoviario.Rodo;
import br.com.swconsultoria.cte.schema_300.distdfeint.DistDFeInt;
import br.com.swconsultoria.cte.schema_300.enviCTe.TCTe;
import br.com.swconsultoria.cte.schema_300.enviCTe.TEnviCTe;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.TEvento;
import br.com.swconsultoria.cte.schema_300.evCCeCTe.TProcEvento;
import br.com.swconsultoria.cte.schema_300.evEPECCTe.TRetEvento;
import br.com.swconsultoria.cte.schema_300.inutCTe.TInutCTe;
import br.com.swconsultoria.cte.schema_300.inutCTe.TProcInutCTe;
import br.com.swconsultoria.cte.schema_300.inutCTe.TRetInutCTe;
import br.com.swconsultoria.cte.schema_300.procCTe.CteProc;
import br.com.swconsultoria.cte.schema_300.procCTeOS.CteOSProc;
import br.com.swconsultoria.cte.schema_300.procCTeOS.TCTeOS;
import br.com.swconsultoria.cte.schema_300.retCTeOS.TProtCTeOS;
import br.com.swconsultoria.cte.schema_300.retCTeOS.TRetCTeOS;
import br.com.swconsultoria.cte.schema_300.retConsReciCTe.TProtCTe;
import br.com.swconsultoria.cte.schema_300.retConsReciCTe.TRetConsReciCTe;
import br.com.swconsultoria.cte.schema_300.retConsSitCTe.TRetConsSitCTe;
import br.com.swconsultoria.cte.schema_300.retEnviCTe.TRetEnviCTe;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import br.com.swconsultoria.cte.util.XsdCteUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XmlCteUtil {
    private static final String STATUS_SERVICO = "TConsStatServ";
    private static final String CTE = "TCTe";
    private static final String CTE_ENV = "br.com.swconsultoria.cte.schema_300.enviCTe.TCTe";
    private static final String CTE_PROC = "br.com.swconsultoria.cte.schema_300.procCTe.TCTe";
    private static final String ENVIO_CTE = "TEnviCTe";
    private static final String ENVIO_CTE_OS = "TCTeOS";
    private static final String CONSULTA_RECIBO = "TConsReciCTe";
    private static final String INUTILIZACAO = "TInutCTe";
    private static final String CONSULTA_PROTOCOLO = "TConsSitCTe";
    private static final String DISTRIBUICAO_DFE = "DistDFeInt";
    private static final String EVENTO = "TEvento";
    private static final String MODAL_RODOVIARIO = "Rodo";
    private static final String MODAL_RODOVIARIO_V3 = "br.com.swconsultoria.cte.schema_300.cteModalRodoviario.Rodo";
    private static final String PROT_CTE = "TProtCTe";
    private static final String PROT_CTEOS = "TProtCTeOS";
    private static final String PROT_CTE_CONSULTA_RECIBO = "br.com.swconsultoria.cte.schema_300.retConsReciCTe.TProtCTe";
    private static final String PROT_CTE_PROC = "br.com.swconsultoria.cte.schema_300.procCTe.TProtCTe";
    private static final String PROT_CTE_CONSULTA_SITUACAO = "br.com.swconsultoria.cte.schema_300.retConsSitCTe.TProtCTe";
    private static final String PROT_CTEOS_PROC = "br.com.swconsultoria.cte.schema_300.retCTeOS.TProtCTeOS";
    private static final String CANCELAR = "br.com.swconsultoria.cte.schema_300.evCancCTe.TEvento";
    private static final String EPEC = "br.com.swconsultoria.cte.schema_300.evEPECCTe.TEvento";
    private static final String MULTIMODAL = "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TEvento";
    private static final String CCE = "br.com.swconsultoria.cte.schema_300.evCCeCTe.TEvento";
    private static final String PRESTDESACORDO = "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TEvento";
    private static final String GVT = "br.com.swconsultoria.cte.schema_300.evGTV.TEvento";
    private static final String RET_EVENTO = "TRetEvento";
    private static final String RET_INUTILIZACAO = "TRetInutCTe";
    private static final String RET_CONSULTA = "TRetConsSitCTe";
    private static final String RET_ENVICTE = "TRetEnviCTe";
    private static final String RET_CTE_OS = "TRetCTeOS";
    private static final String RET_CONSULTA_RECIBO = "TRetConsReciCTe";
    private static final String RET_CANCELAR = "br.com.swconsultoria.cte.schema_300.evCancCTe.TRetEvento";
    private static final String RET_EPEC = "br.com.swconsultoria.cte.schema_300.evEPECCTe.TRetEvento";
    private static final String RET_MULTIMODAL = "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TRetEvento";
    private static final String RET_CCE = "br.com.swconsultoria.cte.schema_300.evCCeCTe.TRetEvento";
    private static final String RET_PRESTDESACORDO = "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TRetEvento";
    private static final String RET_GVT = "br.com.swconsultoria.cte.schema_300.evGTV.TRetEvento";
    private static final String PROC_CANCELAR = "br.com.swconsultoria.cte.schema_300.evCancCTe.TProcEvento";
    private static final String PROC_EPEC = "br.com.swconsultoria.cte.schema_300.evEPECCTe.TProcEvento";
    private static final String PROC_MULTIMODAL = "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TProcEvento";
    private static final String PROC_CCE = "br.com.swconsultoria.cte.schema_300.evCCeCTe.TProcEvento";
    private static final String PROC_PRESTDESACORDO = "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TProcEvento";
    private static final String PROC_GVT = "br.com.swconsultoria.cte.schema_300.evGTV.TProcEvento";
    private static final String PROC_EVENTO = "TProcEvento";
    private static final String PROC_CTE = "CteProc";
    private static final String PROC_CTEOS = "CteOSProc";
    private static final String PROC_INUTILIZAR = "TProcInutCTe";

    public static <T> T xmlToObject(String xml, Class<T> classe) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classe});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)), classe).getValue();
    }

    public static <T> String objectToXml(Object obj) throws JAXBException, CteException {
        Object element;
        JAXBContext context;
        block24 : switch (obj.getClass().getSimpleName()) {
            case "TConsStatServ": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsStatServ.class});
                element = new br.com.swconsultoria.cte.schema_300.consStatServCTe.ObjectFactory().createConsStatServCte((TConsStatServ)obj);
                break;
            }
            case "TEnviCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TEnviCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.enviCTe.ObjectFactory().createEnviCTe((TEnviCTe)obj);
                break;
            }
            case "TCTeOS": {
                context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.cteOS.TCTeOS.class});
                element = new br.com.swconsultoria.cte.schema_300.cteOS.ObjectFactory().createCTeOS((br.com.swconsultoria.cte.schema_300.cteOS.TCTeOS)obj);
                break;
            }
            case "TCTe": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.procCTe.TCTe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.procCTe.TCTe.class});
                        element = XsdCteUtil.cte.createTCTe((br.com.swconsultoria.cte.schema_300.procCTe.TCTe)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.enviCTe.TCTe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TCTe.class});
                        element = XsdCteUtil.cte.createTCTe((TCTe)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "TConsReciCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsReciCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.consReciCTe.ObjectFactory().createConsReciCTe((TConsReciCTe)obj);
                break;
            }
            case "TInutCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TInutCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.inutCTe.ObjectFactory().createInutCTe((TInutCTe)obj);
                break;
            }
            case "TConsSitCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsSitCTe.class});
                element = new ObjectFactory().createConsSitCTe((TConsSitCTe)obj);
                break;
            }
            case "DistDFeInt": {
                context = JAXBContext.newInstance((Class[])new Class[]{DistDFeInt.class});
                element = new br.com.swconsultoria.cte.schema_300.distdfeint.ObjectFactory().createDistDFeInt((DistDFeInt)obj);
                break;
            }
            case "TRetEnviCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetEnviCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.retEnviCTe.ObjectFactory().createRetEnviCte((TRetEnviCTe)obj);
                break;
            }
            case "TRetCTeOS": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetCTeOS.class});
                element = new br.com.swconsultoria.cte.schema_300.retCTeOS.ObjectFactory().createRetCTeOS((TRetCTeOS)obj);
                break;
            }
            case "TRetConsReciCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsReciCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.retConsReciCTe.ObjectFactory().createRetConsReciCTe((TRetConsReciCTe)obj);
                break;
            }
            case "TRetInutCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetInutCTe.class});
                element = XsdCteUtil.retInutilizacao.createTRetInutCTe((TRetInutCTe)obj);
                break;
            }
            case "TRetConsSitCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsSitCTe.class});
                element = new br.com.swconsultoria.cte.schema_300.retConsSitCTe.ObjectFactory().createRetConsSitCTe((TRetConsSitCTe)obj);
                break;
            }
            case "TProcEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.evCancCTe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evCancCTe.TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((br.com.swconsultoria.cte.schema_300.evCancCTe.TProcEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evEPECCTe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evEPECCTe.TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((br.com.swconsultoria.cte.schema_300.evEPECCTe.TProcEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evEPECCTe.TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((br.com.swconsultoria.cte.schema_300.evRegMultimodal.TProcEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evCCeCTe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((TProcEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TProcEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evGTV.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evGTV.TProcEvento.class});
                        element = XsdCteUtil.procEvento.createTProcEvento((br.com.swconsultoria.cte.schema_300.evGTV.TProcEvento)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "CteProc": {
                context = JAXBContext.newInstance((Class[])new Class[]{CteProc.class});
                element = XsdCteUtil.cteProc.createCteProc((CteProc)obj);
                break;
            }
            case "TProcInutCTe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TProcInutCTe.class});
                element = XsdCteUtil.procInut.createProcInut((TProcInutCTe)obj);
                break;
            }
            case "CteOSProc": {
                context = JAXBContext.newInstance((Class[])new Class[]{CteOSProc.class});
                element = XsdCteUtil.cteOSProc.createCteOSProc((CteOSProc)obj);
                break;
            }
            case "TEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.evCancCTe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evCancCTe.TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((br.com.swconsultoria.cte.schema_300.evCancCTe.TEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evEPECCTe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evEPECCTe.TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((br.com.swconsultoria.cte.schema_300.evEPECCTe.TEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evRegMultimodal.TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((br.com.swconsultoria.cte.schema_300.evRegMultimodal.TEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evCCeCTe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((TEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evGTV.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evGTV.TEvento.class});
                        element = XsdCteUtil.evento.createTEvento((br.com.swconsultoria.cte.schema_300.evGTV.TEvento)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "TRetEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.evCancCTe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evCancCTe.TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((br.com.swconsultoria.cte.schema_300.evCancCTe.TRetEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evEPECCTe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((TRetEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evRegMultimodal.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evRegMultimodal.TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((br.com.swconsultoria.cte.schema_300.evRegMultimodal.TRetEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evCCeCTe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evCCeCTe.TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((br.com.swconsultoria.cte.schema_300.evCCeCTe.TRetEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((br.com.swconsultoria.cte.schema_300.evPrestDesacordo.TRetEvento)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.evGTV.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.evGTV.TRetEvento.class});
                        element = XsdCteUtil.retEvento.createTRetEvent((br.com.swconsultoria.cte.schema_300.evGTV.TRetEvento)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "TProtCTe": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.retConsReciCTe.TProtCTe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TProtCTe.class});
                        element = XsdCteUtil.protCTe.createProtCte((TProtCTe)obj);
                        break block24;
                    }
                    case "br.com.swconsultoria.cte.schema_300.procCTe.TProtCTe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.cte.schema_300.procCTe.TProtCTe.class});
                        element = XsdCteUtil.protCTe.createProtCte((br.com.swconsultoria.cte.schema_300.procCTe.TProtCTe)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "TProtCTeOS": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.cte.schema_300.retCTeOS.TProtCTeOS": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TProtCTeOS.class});
                        element = XsdCteUtil.protCTe.createProtCte((TProtCTeOS)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            case "Rodo": {
                switch (obj.getClass().getName()) {
                    case "Rodo": {
                        context = JAXBContext.newInstance((Class[])new Class[]{Rodo.class});
                        element = XsdCteUtil.rodo.createRodo((Rodo)obj);
                        break block24;
                    }
                }
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getName());
            }
            default: {
                throw new CteException("Objeto n\u00e3o mapeado no XmlCteUtil:" + obj.getClass().getSimpleName());
            }
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        marshaller.marshal(element, (Writer)sw);
        return XmlCteUtil.replacesCte("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sw.toString());
    }

    public static String gZipToXml(byte[] conteudo) throws IOException {
        String line;
        if (conteudo == null || conteudo.length == 0) {
            return "";
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        StringBuilder outStr = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            outStr.append(line);
        }
        return outStr.toString();
    }

    public static String criaCteProc(TEnviCTe enviCte, Object retorno) throws JAXBException, CteException {
        CteProc cteProc2 = new CteProc();
        cteProc2.setVersao("3.00");
        cteProc2.setCTe(XmlCteUtil.xmlToObject(XmlCteUtil.objectToXml(enviCte.getCTe().get(0)), br.com.swconsultoria.cte.schema_300.procCTe.TCTe.class));
        cteProc2.setProtCTe(XmlCteUtil.xmlToObject(XmlCteUtil.objectToXml(retorno), br.com.swconsultoria.cte.schema_300.procCTe.TProtCTe.class));
        return XmlCteUtil.objectToXml(cteProc2);
    }

    public static String criaCteOSProc(br.com.swconsultoria.cte.schema_300.cteOS.TCTeOS enviCte, Object retorno) throws JAXBException, CteException {
        CteOSProc cteProc2 = new CteOSProc();
        cteProc2.setVersao("3.00");
        cteProc2.setCTeOS(XmlCteUtil.xmlToObject(XmlCteUtil.objectToXml(enviCte), TCTeOS.class));
        cteProc2.setProtCTe(XmlCteUtil.xmlToObject(XmlCteUtil.objectToXml(retorno), br.com.swconsultoria.cte.schema_300.procCTeOS.TProtCTeOS.class));
        return XmlCteUtil.objectToXml(cteProc2);
    }

    public static String leXml(String arquivo) throws IOException {
        ObjetoCTeUtil.verifica(arquivo).orElseThrow(() -> new IllegalArgumentException("Arquivo xml n\u00e3o pode ser nulo/vazio."));
        if (!Files.exists(Paths.get(arquivo, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Arquivo " + arquivo + " n\u00e3o encontrado.");
        }
        List<String> list = Files.readAllLines(Paths.get(arquivo, new String[0]));
        StringJoiner joiner = new StringJoiner("\n");
        list.forEach(joiner::add);
        return joiner.toString();
    }

    private static String replacesCte(String xml) {
        xml = xml.replaceAll("ns2:", "");
        xml = xml.replaceAll("ns3:", "");
        xml = xml.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&gt;", ">");
        xml = xml.replaceAll("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">");
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replaceAll(" xmlns:ns3=\"http://www.portalfiscal.inf.br/cte\"", "");
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.portalfiscal.inf.br/cte\"", "");
        xml = xml.replaceAll(" xmlns=\"\"", "");
        return xml;
    }

    public static String dataCte(LocalDateTime dataASerFormatada) {
        return XmlCteUtil.dataCte(dataASerFormatada, ZoneId.systemDefault());
    }

    public static String dataCte(LocalDateTime dataASerFormatada, ZoneId zoneId) {
        try {
            GregorianCalendar calendar = GregorianCalendar.from(dataASerFormatada.atZone(ObjetoCTeUtil.verifica(zoneId).orElse(ZoneId.of("Brazil/East"))));
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlCalendar.setMillisecond(Integer.MIN_VALUE);
            return xmlCalendar.toString();
        }
        catch (DatatypeConfigurationException e) {
            LoggerUtil.log(XmlCteUtil.class, e.getMessage());
            return null;
        }
    }
}

