/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe;

import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.schema_300.consMDFeNaoEnc.TConsMDFeNaoEnc;
import br.com.swconsultoria.mdfe.schema_300.retConsMDFeNaoEnc.TRetConsMDFeNaoEnc;
import br.com.swconsultoria.mdfe.util.WebServiceMdfeUtil;
import br.com.swconsultoria.mdfe.util.XmlMdfeUtil;
import br.com.swconsultoria.mdfe.wsdl.MDFeConsNaoEnc.MDFeConsNaoEncStub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class ConsultarNaoEncerrado {
    private static final Logger log = Logger.getLogger(ConsultarNaoEncerrado.class.getName());

    private ConsultarNaoEncerrado() {
    }

    static TRetConsMDFeNaoEnc consultar(ConfiguracoesMDFe config, String cnpj) throws MdfeException {
        try {
            TConsMDFeNaoEnc consMDFeNaoEnc = new TConsMDFeNaoEnc();
            consMDFeNaoEnc.setCNPJ(cnpj);
            consMDFeNaoEnc.setTpAmb(config.getAmbiente().getCodigo());
            consMDFeNaoEnc.setVersao("3.00");
            consMDFeNaoEnc.setXServ("CONSULTAR N\u00c3O ENCERRADOS");
            String xml = XmlMdfeUtil.objectMdfeToXml(consMDFeNaoEnc);
            log.info("[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            MDFeConsNaoEncStub.MdfeCabecMsg cabecMsg = new MDFeConsNaoEncStub.MdfeCabecMsg();
            cabecMsg.setCUF(config.getEstado().getCodigoUF());
            cabecMsg.setVersaoDados("3.00");
            MDFeConsNaoEncStub.MdfeDadosMsg dadosMsg = new MDFeConsNaoEncStub.MdfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            MDFeConsNaoEncStub.MdfeCabecMsgE cabecMsgE = new MDFeConsNaoEncStub.MdfeCabecMsgE();
            cabecMsgE.setMdfeCabecMsg(cabecMsg);
            String url = WebServiceMdfeUtil.getUrl(config, "MDFeConsNaoEnc");
            MDFeConsNaoEncStub stub = new MDFeConsNaoEncStub(url);
            MDFeConsNaoEncStub.MdfeConsNaoEncResult result = stub.mdfeConsNaoEnc(dadosMsg, cabecMsgE);
            return XmlMdfeUtil.xmlToObject(result.getExtraElement().toString(), TRetConsMDFeNaoEnc.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new MdfeException(e.getMessage());
        }
    }
}

