/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe;

import br.com.swconsultoria.mdfe.AssinaturaMdfe;
import br.com.swconsultoria.mdfe.ValidarMDFe;
import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.schema_300.mdfe.TMDFe;
import br.com.swconsultoria.mdfe.schema_300.mdfe.TRetMDFe;
import br.com.swconsultoria.mdfe.util.ObjetoMdfeUtil;
import br.com.swconsultoria.mdfe.util.WebServiceMdfeUtil;
import br.com.swconsultoria.mdfe.util.XmlMdfeUtil;
import br.com.swconsultoria.mdfe.wsdl.MDFeRecepcaoSinc.MDFeRecepcaoSincStub;
import java.io.IOException;
import java.util.Base64;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

class EnvioMdfe {
    private static final Logger log = Logger.getLogger(EnvioMdfe.class.getName());

    private EnvioMdfe() {
    }

    static TMDFe montaMdfe(ConfiguracoesMDFe config, TMDFe enviMdfe, boolean validar) throws MdfeException {
        try {
            String erros;
            String xml = AssinaturaMdfe.assinar(config, XmlMdfeUtil.objectMdfeToXml(enviMdfe), "MDFe_SINC");
            if (validar && !ObjetoMdfeUtil.isEmpty(erros = ValidarMDFe.validaXml(config, xml, "MDFeRecepcaoSinc"))) {
                throw new MdfeException("Erro Na Valida\u00e7\u00e3o do Xml: " + erros);
            }
            log.info("[XML-ASSINADO]: " + xml);
            return XmlMdfeUtil.xmlToObject(xml, TMDFe.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static TRetMDFe enviarMdfeSincrono(ConfiguracoesMDFe configuracoes, TMDFe mdfe2) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(mdfe2);
            log.info("[XML-ENVIO]: " + xml);
            MDFeRecepcaoSincStub.MdfeDadosMsg dadosMsg = new MDFeRecepcaoSincStub.MdfeDadosMsg();
            dadosMsg.setMdfeDadosMsg(Base64.getEncoder().encodeToString(XmlMdfeUtil.gZip(xml)));
            MDFeRecepcaoSincStub stub = new MDFeRecepcaoSincStub(WebServiceMdfeUtil.getUrl(configuracoes, "MDFeRecepcaoSinc"));
            return XmlMdfeUtil.xmlToObject(stub.mdfeRecepcao(dadosMsg).getExtraElement().toString(), TRetMDFe.class);
        }
        catch (IOException | JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }
}

