/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe;

import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.schema_300.consStatServMDFe.TConsStatServ;
import br.com.swconsultoria.mdfe.schema_300.retConsStatServMDFe.TRetConsStatServ;
import br.com.swconsultoria.mdfe.util.WebServiceMdfeUtil;
import br.com.swconsultoria.mdfe.util.XmlMdfeUtil;
import br.com.swconsultoria.mdfe.wsdl.MDFeStatusServico.MDFeStatusServicoStub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class StatusServico {
    private static final Logger log = Logger.getLogger(StatusServico.class.getName());

    private StatusServico() {
    }

    static TRetConsStatServ statusServico(ConfiguracoesMDFe configuracoes) throws MdfeException {
        try {
            TConsStatServ consulta = new TConsStatServ();
            consulta.setTpAmb(configuracoes.getAmbiente().getCodigo());
            consulta.setVersao("3.00");
            consulta.setXServ("STATUS");
            String xml = XmlMdfeUtil.objectMdfeToXml(consulta);
            log.info("[XML-STATUS]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            MDFeStatusServicoStub.MdfeDadosMsg dadosMsg = new MDFeStatusServicoStub.MdfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            MDFeStatusServicoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeStatusServicoStub.MdfeCabecMsg();
            mdfeCabecMsg.setCUF(configuracoes.getEstado().getCodigoUF());
            mdfeCabecMsg.setVersaoDados("3.00");
            MDFeStatusServicoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeStatusServicoStub.MdfeCabecMsgE();
            mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
            MDFeStatusServicoStub stub = new MDFeStatusServicoStub(WebServiceMdfeUtil.getUrl(configuracoes, "MDFeStatusServico"));
            return XmlMdfeUtil.xmlToObject(stub.mdfeStatusServicoMDF(dadosMsg, mdfeCabecMsgE).getExtraElement().toString(), TRetConsStatServ.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new MdfeException(e.getMessage());
        }
    }
}

