/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.dom;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.mdfe.dom.Proxy;
import br.com.swconsultoria.mdfe.dom.enuns.AmbienteEnum;
import br.com.swconsultoria.mdfe.dom.enuns.EstadosEnum;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public final class ConfiguracoesMDFe {
    private static final Logger log = Logger.getLogger(ConfiguracoesMDFe.class.getName());
    private Certificado certificado;
    private String pastaSchemas;
    private EstadosEnum estado;
    private AmbienteEnum ambiente;
    private boolean validacaoDocumento = true;
    private InputStream cacert;
    private Proxy proxy;

    private ConfiguracoesMDFe() {
    }

    public static ConfiguracoesMDFe criarConfiguracoes(EstadosEnum estado, AmbienteEnum ambiente, Certificado certificado, String pastaSchemas) throws CertificadoException {
        ConfiguracoesMDFe configuracoesMdfe = new ConfiguracoesMDFe();
        configuracoesMdfe.setEstado(estado);
        configuracoesMdfe.setAmbiente(ambiente);
        configuracoesMdfe.setCertificado(certificado);
        configuracoesMdfe.setPastaSchemas(pastaSchemas);
        if (Integer.parseInt(System.getProperty("java.class.version").substring(0, 2)) < 56) {
            try {
                System.setProperty("file.encoding", "UTF-8");
                Field charset = Charset.class.getDeclaredField("defaultCharset");
                charset.setAccessible(true);
                charset.set(null, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new CertificadoException("Erro ao setar Encoding.");
            }
        }
        log.info(String.format("JAVA-MDFE | Samuel Oliveira | samuel@swconsultoria.com.br | VERSAO=%s | DATA_VERSAO=%s | PASTA_SCHEMAS=%s | AMBIENTE=%s | ESTADO=%s", new Object[]{"3.00.15", "18/06/2024", pastaSchemas, ambiente, estado.getNome().toUpperCase()}));
        if (!certificado.isValido()) {
            throw new CertificadoException("Certificado Vencido/Inv\u00e1lido.");
        }
        return configuracoesMdfe;
    }

    public Certificado getCertificado() {
        return this.certificado;
    }

    public String getPastaSchemas() {
        return this.pastaSchemas;
    }

    public EstadosEnum getEstado() {
        return this.estado;
    }

    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public boolean isValidacaoDocumento() {
        return this.validacaoDocumento;
    }

    public InputStream getCacert() {
        return this.cacert;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setCertificado(Certificado certificado) {
        this.certificado = certificado;
    }

    public void setPastaSchemas(String pastaSchemas) {
        this.pastaSchemas = pastaSchemas;
    }

    public void setEstado(EstadosEnum estado) {
        this.estado = estado;
    }

    public void setAmbiente(AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setValidacaoDocumento(boolean validacaoDocumento) {
        this.validacaoDocumento = validacaoDocumento;
    }

    public void setCacert(InputStream cacert) {
        this.cacert = cacert;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

