/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.util;

import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Valida
implements ErrorHandler {
    protected static String xsd;
    protected static ConfiguracoesMDFe configuracoes;
    private String listaComErrosDeValidacao = "";

    protected Valida() {
    }

    protected String validateXml(String xml, String xsd) throws MdfeException {
        DocumentBuilder builder;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsd);
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException ex) {
            throw new MdfeException(ex.getMessage());
        }
        try {
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception ex) {
            throw new MdfeException(ex.toString());
        }
        return this.getListaComErrosDeValidacao();
    }

    @Override
    public void error(SAXParseException exception) {
        if (this.isError(exception)) {
            this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    @Override
    public void warning(SAXParseException exception) {
        this.listaComErrosDeValidacao = this.listaComErrosDeValidacao + this.tratamentoRetorno(exception.getMessage());
    }

    private String tratamentoRetorno(String message) {
        message = message.replace("cvc-type.3.1.3:", "-").replace("cvc-attribute.3:", "-").replace("cvc-complex-type.2.4.a:", "-").replace("cvc-complex-type.2.4.b:", "-").replace("cvc-complex-type.2.4.c:", "-").replace("cvc-complex-type.2.4.d:", "-").replace("cvc-complex-type.4:", "-").replace("cvc-minLength-valid:", "-").replace("The value", "O valor").replace("Value", "Valor").replace("with length", "com tamanho").replace("is not facet-valid with respect to minLength", "n\u00e3o equivale ao tamanho m\u00ednimo").replace("for type", "para o tipo").replace("The content", "O conte\u00fado").replace("of element", "do campo").replace("is not complete", "n\u00e3o est\u00e1 completo").replace("is not valid", "n\u00e3o \u00e9 v\u00e1lido").replace("Attribute", "Campo").replace("must appear on element", "precisa estar em").replace("Invalid content was found starting with element", "Conte\u00fado inv\u00e1lido encontrado iniciando com o campo").replace("One of", "Um dos Campos").replace("is expected", "\u00e9 esperado").replace("\\{", "").replace("\\}", "").replace("\"", "").replace("http://www.portalfiscal.inf.br/mdfe:", "");
        return System.lineSeparator() + message.trim();
    }

    public String getListaComErrosDeValidacao() {
        return this.listaComErrosDeValidacao;
    }

    private boolean isError(SAXParseException exception) {
        return !exception.getMessage().startsWith("cvc-enumeration-valid") && !exception.getMessage().startsWith("cvc-pattern-valid") && !exception.getMessage().startsWith("cvc-maxLength-valid") && !exception.getMessage().startsWith("cvc-datatype");
    }
}

