/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.util.ConfiguracoesUtil;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ConsultaTributacao {
    @Generated
    private static final Logger log = Logger.getLogger(ConsultaTributacao.class.getName());
    private static final String SECTION = "CFF";
    private static final String KEY = "classTrib";
    private static final ObjectMapper MAPPER = ConsultaTributacao.createObjectMapper();
    private static final ObjectMapper STRICT_MAPPER = ConsultaTributacao.createStrictObjectMapper();

    private ConsultaTributacao() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return mapper;
    }

    private static ObjectMapper createStrictObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true);
        return mapper;
    }

    public static String getJson(ConfiguracoesNfe config) throws NfeException, IOException {
        return ConsultaTributacao.getJson(config, null);
    }

    public static String getJson(ConfiguracoesNfe config, Map<String, String> queryParams) throws NfeException, IOException {
        ConfiguracoesUtil.iniciaConfiguracoes(config);
        String urlBase = WebServiceUtil.getCustomUrl(config, SECTION, KEY);
        String url = ConsultaTributacao.buildUrlWithParams(urlBase, queryParams);
        Certificado certificado = config.getCertificado();
        if (certificado == null) {
            throw new NfeException("Certificado digital n\u00e3o configurado");
        }
        try {
            HttpClient httpClient = ConsultaTributacao.createHttpClient(config, certificado, url);
            if (httpClient != null) {
                return ConsultaTributacao.executeRequestWithHttpClient(httpClient, url);
            }
        }
        catch (CertificadoException e) {
            log.warning("[ConsultaTributacao] Falha ao criar HttpClient, tentando fallback: " + e.getMessage());
        }
        SSLSocketFactory sslFactory = ConsultaTributacao.tryResolveSslSocketFactory(config);
        if (sslFactory != null) {
            return ConsultaTributacao.executeRequestWithSslFactory(sslFactory, url);
        }
        throw new NfeException("N\u00e3o foi poss\u00edvel configurar SSL/TLS para a requisi\u00e7\u00e3o.");
    }

    public static <T> T get(ConfiguracoesNfe config, Class<T> clazz) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config);
        return ConsultaTributacao.convertJsonToObject(json, clazz);
    }

    public static <T> T get(ConfiguracoesNfe config, Map<String, String> queryParams, Class<T> clazz) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config, queryParams);
        return ConsultaTributacao.convertJsonToObject(json, clazz);
    }

    public static <T> T get(ConfiguracoesNfe config, TypeReference<T> typeRef) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config);
        return ConsultaTributacao.convertJsonToObject(json, typeRef);
    }

    public static <T> T get(ConfiguracoesNfe config, Map<String, String> queryParams, TypeReference<T> typeRef) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config, queryParams);
        return ConsultaTributacao.convertJsonToObject(json, typeRef);
    }

    public static ValidationReport validate(ConfiguracoesNfe config, Class<?> clazz) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config);
        return ConsultaTributacao.validateJsonStructure(json, clazz);
    }

    public static ValidationReport validate(ConfiguracoesNfe config, Map<String, String> queryParams, Class<?> clazz) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config, queryParams);
        return ConsultaTributacao.validateJsonStructure(json, clazz);
    }

    public static ValidationReport validate(ConfiguracoesNfe config, TypeReference<?> typeRef, Class<?> innerClass) throws NfeException, IOException {
        String json = ConsultaTributacao.getJson(config);
        return ConsultaTributacao.validateJsonStructure(json, innerClass);
    }

    public static boolean isCompatible(ConfiguracoesNfe config, Class<?> clazz) {
        try {
            String json = ConsultaTributacao.getJson(config);
            STRICT_MAPPER.readValue(json, clazz);
            return true;
        }
        catch (Exception e) {
            log.warning("[ConsultaTributacao] Incompatibilidade detectada: " + e.getMessage());
            return false;
        }
    }

    private static ValidationReport validateJsonStructure(String json, Class<?> clazz) throws NfeException {
        ValidationReport report = new ValidationReport();
        try {
            JsonNode rootNode;
            JsonNode nodeToValidate = rootNode = MAPPER.readTree(json);
            if (rootNode.isArray() && rootNode.size() > 0) {
                nodeToValidate = rootNode.get(0);
                report.setArrayDetected(true);
                report.setArraySize(rootNode.size());
            }
            Map<String, Class<?>> expectedFields = ConsultaTributacao.extractDtoFields(clazz);
            HashSet jsonFields = new HashSet();
            Iterator fieldNames = nodeToValidate.fieldNames();
            while (fieldNames.hasNext()) {
                jsonFields.add(fieldNames.next());
            }
            HashSet<String> extraFields = new HashSet<String>(jsonFields);
            extraFields.removeAll(expectedFields.keySet());
            report.setExtraFields(extraFields);
            HashSet<String> missingFields = new HashSet<String>(expectedFields.keySet());
            missingFields.removeAll(jsonFields);
            report.setMissingFields(missingFields);
            HashMap<String, String> typeErrors = new HashMap<String, String>();
            for (Map.Entry<String, Class<?>> entry : expectedFields.entrySet()) {
                JsonNode fieldNode;
                String fieldName = entry.getKey();
                Class<?> expectedType = entry.getValue();
                if (!jsonFields.contains(fieldName) || ConsultaTributacao.isTypeCompatible(fieldNode = nodeToValidate.get(fieldName), expectedType)) continue;
                typeErrors.put(fieldName, "Esperado: " + expectedType.getSimpleName() + ", Encontrado: " + ConsultaTributacao.getJsonNodeType(fieldNode));
            }
            report.setTypeErrors(typeErrors);
            try {
                STRICT_MAPPER.readValue(json, clazz);
                report.setStrictConversionSuccess(true);
            }
            catch (Exception e) {
                report.setStrictConversionSuccess(false);
                report.setStrictConversionError(e.getMessage());
            }
        }
        catch (IOException e) {
            throw new NfeException("Erro ao validar JSON: " + e.getMessage(), e);
        }
        return report;
    }

    private static Map<String, Class<?>> extractDtoFields(Class<?> clazz) {
        HashMap fields = new HashMap();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            JsonProperty annotation = field.getAnnotation(JsonProperty.class);
            String jsonFieldName = annotation != null && !annotation.value().isEmpty() ? annotation.value() : field.getName();
            fields.put(jsonFieldName, field.getType());
        }
        return fields;
    }

    private static boolean isTypeCompatible(JsonNode node, Class<?> expectedType) {
        if (node.isNull()) {
            return true;
        }
        if (expectedType == String.class) {
            return node.isTextual();
        }
        if (expectedType == Integer.class || expectedType == Integer.TYPE || expectedType == Long.class || expectedType == Long.TYPE || expectedType == Short.class || expectedType == Short.TYPE || expectedType == Byte.class || expectedType == Byte.TYPE) {
            return node.isIntegralNumber();
        }
        if (expectedType == Double.class || expectedType == Double.TYPE || expectedType == Float.class || expectedType == Float.TYPE || expectedType == BigDecimal.class) {
            return node.isNumber();
        }
        if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
            return node.isBoolean();
        }
        if (List.class.isAssignableFrom(expectedType) || Collection.class.isAssignableFrom(expectedType)) {
            return node.isArray();
        }
        if (Map.class.isAssignableFrom(expectedType)) {
            return node.isObject();
        }
        return node.isObject();
    }

    private static String getJsonNodeType(JsonNode node) {
        if (node.isNull()) {
            return "null";
        }
        if (node.isTextual()) {
            return "String";
        }
        if (node.isIntegralNumber()) {
            return "Integer";
        }
        if (node.isFloatingPointNumber()) {
            return "Decimal";
        }
        if (node.isBoolean()) {
            return "Boolean";
        }
        if (node.isArray()) {
            return "Array";
        }
        if (node.isObject()) {
            return "Object";
        }
        return "Unknown";
    }

    public static <T> T convertJsonToObject(String json, Class<T> clazz) throws NfeException {
        try {
            log.info("[ConsultaTributacao] Convertendo JSON para " + clazz.getSimpleName());
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            log.severe("[ConsultaTributacao] Erro ao converter JSON: " + e.getMessage());
            throw new NfeException("Erro ao processar resposta JSON: " + e.getMessage(), e);
        }
    }

    public static <T> T convertJsonToObject(String json, TypeReference<T> typeRef) throws NfeException {
        try {
            log.info("[ConsultaTributacao] Convertendo JSON para tipo complexo");
            return (T)MAPPER.readValue(json, typeRef);
        }
        catch (IOException e) {
            log.severe("[ConsultaTributacao] Erro ao converter JSON: " + e.getMessage());
            throw new NfeException("Erro ao processar resposta JSON: " + e.getMessage(), e);
        }
    }

    private static String buildUrlWithParams(String baseUrl, Map<String, String> queryParams) {
        if (queryParams == null || queryParams.isEmpty()) {
            return baseUrl;
        }
        StringBuilder url = new StringBuilder(baseUrl);
        boolean first = !baseUrl.contains("?");
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            if (entry.getValue() == null || entry.getValue().trim().isEmpty()) continue;
            url.append(first ? "?" : "&");
            url.append(entry.getKey()).append("=").append(entry.getValue());
            first = false;
        }
        return url.toString();
    }

    private static HttpClient createHttpClient(ConfiguracoesNfe config, Certificado certificado, String url) throws CertificadoException {
        if (ObjetoUtil.verifica(config.getCacert()).isPresent()) {
            return CertificadoService.getHttpsClient((Certificado)certificado, (String)url, (InputStream)config.getCacert());
        }
        return CertificadoService.getHttpsClient((Certificado)certificado, (String)url);
    }

    /*
     * Loose catch block
     */
    private static String executeRequestWithHttpClient(HttpClient httpClient, String url) throws IOException {
        GetMethod getMethod = new GetMethod(url);
        try {
            getMethod.setRequestHeader("Accept", "application/json");
            getMethod.setRequestHeader("Content-Type", "application/json; charset=UTF-8");
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            log.info("[ConsultaTributacao] Status HTTP: " + statusCode);
            if (statusCode != 200) {
                String errorBody = ConsultaTributacao.inputStreamToString(getMethod.getResponseBodyAsStream());
                log.severe("[ConsultaTributacao] Erro HTTP " + statusCode + ": " + errorBody);
                throw new IOException("Erro HTTP " + statusCode + ": " + errorBody);
            }
            try (BufferedInputStream responseStream = new BufferedInputStream(getMethod.getResponseBodyAsStream());){
                String string = ConsultaTributacao.inputStreamToString(responseStream);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeRequestWithSslFactory(SSLSocketFactory sslFactory, String url) throws IOException {
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            URL u = new URL(url);
            conn = (HttpsURLConnection)u.openConnection();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslFactory);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(30000);
            conn.setDoInput(true);
            int statusCode = conn.getResponseCode();
            log.info("[ConsultaTributacao] Status HTTP: " + statusCode);
            if (statusCode != 200) {
                String errorBody = ConsultaTributacao.inputStreamToString(conn.getErrorStream());
                log.severe("[ConsultaTributacao] Erro HTTP " + statusCode + ": " + errorBody);
                throw new IOException("Erro HTTP " + statusCode + ": " + errorBody);
            }
            is = new BufferedInputStream(conn.getInputStream());
            String string = ConsultaTributacao.inputStreamToString(is);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static SSLSocketFactory tryResolveSslSocketFactory(ConfiguracoesNfe config) {
        Object res2;
        Method m22;
        Object res;
        Method m3;
        try {
            Class<?> svc = Class.forName("br.com.swconsultoria.certificado.CertificadoService");
            try {
                m3 = svc.getMethod("getSSLSocketFactory", Class.forName("br.com.swconsultoria.certificado. Certificado"));
                res = m3.invoke(null, config.getCertificado());
                if (res instanceof SSLSocketFactory) {
                    return (SSLSocketFactory)res;
                }
            }
            catch (NoSuchMethodException m3) {
                // empty catch block
            }
            try {
                m22 = svc.getMethod("getSslContext", Class.forName("br.com.swconsultoria.certificado.Certificado"));
                res2 = m22.invoke(null, config.getCertificado());
                if (res2 instanceof SSLContext) {
                    return ((SSLContext)res2).getSocketFactory();
                }
            }
            catch (NoSuchMethodException m22) {}
        }
        catch (Throwable svc) {
            // empty catch block
        }
        Certificado cert = config.getCertificado();
        if (cert != null) {
            try {
                m3 = cert.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                res = m3.invoke((Object)cert, new Object[0]);
                if (res instanceof SSLSocketFactory) {
                    return (SSLSocketFactory)res;
                }
            }
            catch (Throwable m4) {
                // empty catch block
            }
            try {
                m22 = cert.getClass().getMethod("getSslContext", new Class[0]);
                res2 = m22.invoke((Object)cert, new Object[0]);
                if (res2 instanceof SSLContext) {
                    return ((SSLContext)res2).getSocketFactory();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static String inputStreamToString(InputStream is) throws IOException {
        int bytesRead;
        if (is == null) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = is.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static class ValidationReport {
        private Set<String> extraFields = new HashSet<String>();
        private Set<String> missingFields = new HashSet<String>();
        private Map<String, String> typeErrors = new HashMap<String, String>();
        private boolean strictConversionSuccess;
        private String strictConversionError;
        private boolean arrayDetected;
        private int arraySize;

        public boolean hasIssues() {
            return !this.extraFields.isEmpty() || !this.missingFields.isEmpty() || !this.typeErrors.isEmpty() || !this.strictConversionSuccess;
        }

        public boolean isValid() {
            return !this.hasIssues();
        }

        public String generateReport() {
            StringBuilder sb = new StringBuilder();
            sb.append("=== RELATORIO DE VALIDACAO ===\n\n");
            if (this.arrayDetected) {
                sb.append("Array detectado com ").append(this.arraySize).append(" elemento(s)\n");
                sb.append("Validacao realizada no primeiro elemento\n\n");
            }
            if (this.extraFields.isEmpty() && this.missingFields.isEmpty() && this.typeErrors.isEmpty()) {
                sb.append("ESTRUTURA 100% COMPATIVEL\n");
                sb.append("  - Nenhum campo extra no JSON\n");
                sb.append("  - Nenhum campo faltando\n");
                sb.append("  - Todos os tipos estao corretos\n");
            } else {
                if (!this.extraFields.isEmpty()) {
                    sb.append("ATENCAO: Campos EXTRAS no JSON (nao mapeados no DTO):\n");
                    for (String string : this.extraFields) {
                        sb.append("  - ").append(string).append("\n");
                    }
                    sb.append("\n");
                }
                if (!this.missingFields.isEmpty()) {
                    sb.append("ATENCAO: Campos FALTANDO no JSON (esperados no DTO):\n");
                    for (String string : this.missingFields) {
                        sb.append("  - ").append(string).append("\n");
                    }
                    sb.append("\n");
                }
                if (!this.typeErrors.isEmpty()) {
                    sb.append("ERRO: Incompatibilidade de tipos:\n");
                    for (Map.Entry entry : this.typeErrors.entrySet()) {
                        sb.append("  - ").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
                    }
                    sb.append("\n");
                }
            }
            sb.append("Conversao estrita: ").append(this.strictConversionSuccess ? "SUCESSO" : "FALHOU").append("\n");
            if (!this.strictConversionSuccess && this.strictConversionError != null) {
                sb.append("  Erro: ").append(this.strictConversionError).append("\n");
            }
            return sb.toString();
        }

        public String toString() {
            return this.generateReport();
        }

        @Generated
        public void setExtraFields(Set<String> extraFields) {
            this.extraFields = extraFields;
        }

        @Generated
        public void setMissingFields(Set<String> missingFields) {
            this.missingFields = missingFields;
        }

        @Generated
        public void setTypeErrors(Map<String, String> typeErrors) {
            this.typeErrors = typeErrors;
        }

        @Generated
        public void setStrictConversionSuccess(boolean strictConversionSuccess) {
            this.strictConversionSuccess = strictConversionSuccess;
        }

        @Generated
        public void setStrictConversionError(String strictConversionError) {
            this.strictConversionError = strictConversionError;
        }

        @Generated
        public void setArrayDetected(boolean arrayDetected) {
            this.arrayDetected = arrayDetected;
        }

        @Generated
        public void setArraySize(int arraySize) {
            this.arraySize = arraySize;
        }

        @Generated
        public Set<String> getExtraFields() {
            return this.extraFields;
        }

        @Generated
        public Set<String> getMissingFields() {
            return this.missingFields;
        }

        @Generated
        public Map<String, String> getTypeErrors() {
            return this.typeErrors;
        }

        @Generated
        public boolean isStrictConversionSuccess() {
            return this.strictConversionSuccess;
        }

        @Generated
        public String getStrictConversionError() {
            return this.strictConversionError;
        }

        @Generated
        public boolean isArrayDetected() {
            return this.arrayDetected;
        }

        @Generated
        public int getArraySize() {
            return this.arraySize;
        }
    }
}

