/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.ConsultaDFeEnum;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.PessoaEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.distdfeint.DistDFeInt;
import br.com.swconsultoria.nfe.schema.retdistdfeint.RetDistDFeInt;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.StubUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.swconsultoria.nfe.wsdl.NFeDistribuicaoDFe.NFeDistribuicaoDFeStub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class DistribuicaoDFe {
    @Generated
    private static final Logger log = Logger.getLogger(DistribuicaoDFe.class.getName());

    private DistribuicaoDFe() {
    }

    static RetDistDFeInt consultaNfe(ConfiguracoesNfe config, PessoaEnum tipoPessoa, String cpfCnpj, ConsultaDFeEnum tipoConsulta, String nsuChave) throws NfeException {
        try {
            DistDFeInt distDFeInt = new DistDFeInt();
            distDFeInt.setVersao("1.01");
            distDFeInt.setTpAmb(config.getAmbiente().getCodigo());
            distDFeInt.setCUFAutor(config.getEstado().getCodigoUF());
            if (PessoaEnum.JURIDICA.equals((Object)tipoPessoa)) {
                distDFeInt.setCNPJ(cpfCnpj);
            } else {
                distDFeInt.setCPF(cpfCnpj);
            }
            switch (tipoConsulta) {
                case NSU: {
                    DistDFeInt.DistNSU distNSU = new DistDFeInt.DistNSU();
                    distNSU.setUltNSU(nsuChave);
                    distDFeInt.setDistNSU(distNSU);
                    break;
                }
                case NSU_UNICO: {
                    DistDFeInt.ConsNSU consNSU = new DistDFeInt.ConsNSU();
                    consNSU.setNSU(nsuChave);
                    distDFeInt.setConsNSU(consNSU);
                    break;
                }
                case CHAVE: {
                    DistDFeInt.ConsChNFe chNFe = new DistDFeInt.ConsChNFe();
                    chNFe.setChNFe(nsuChave);
                    distDFeInt.setConsChNFe(chNFe);
                }
            }
            String xml = XmlNfeUtil.objectToXml(distDFeInt, config.getEncode());
            log.info("[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            NFeDistribuicaoDFeStub.NfeDadosMsg_type0 dadosMsgType0 = new NFeDistribuicaoDFeStub.NfeDadosMsg_type0();
            dadosMsgType0.setExtraElement(ome);
            NFeDistribuicaoDFeStub.NfeDistDFeInteresse distDFeInteresse = new NFeDistribuicaoDFeStub.NfeDistDFeInteresse();
            distDFeInteresse.setNfeDadosMsg(dadosMsgType0);
            String url = WebServiceUtil.getUrl(config, DocumentoEnum.NFE, ServicosEnum.DISTRIBUICAO_DFE);
            NFeDistribuicaoDFeStub stub = new NFeDistribuicaoDFeStub(url);
            StubUtil.configuraHttpClient(stub, config, url);
            if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            NFeDistribuicaoDFeStub.NfeDistDFeInteresseResponse result = stub.nfeDistDFeInteresse(distDFeInteresse);
            log.info("[XML-RETORNO]: " + result.getNfeDistDFeInteresseResult().getExtraElement().toString());
            return XmlNfeUtil.xmlToObject(result.getNfeDistDFeInteresseResult().getExtraElement().toString(), RetDistDFeInt.class);
        }
        catch (CertificadoException | RemoteException | JAXBException | XMLStreamException e) {
            throw new NfeException(e.getMessage(), e);
        }
    }
}

