/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Optional;

public class NFCeUtil {
    @Deprecated
    public static String getCodeQRCode(String chave, String ambiente, String idToken, String CSC, String urlConsulta) throws NoSuchAlgorithmException {
        StringBuilder value = new StringBuilder();
        value.append(chave);
        value.append("|").append("2");
        value.append("|").append(ambiente);
        value.append("|").append(Integer.valueOf(idToken));
        String cHashQRCode = NFCeUtil.getHexa(NFCeUtil.getHash(value.toString() + CSC)).toUpperCase();
        return urlConsulta + "?p=" + value + "|" + cHashQRCode;
    }

    public static String getCodeQRCodeV3(String chave, String ambiente, String urlConsulta) {
        return String.format("%s?p=%s|3|%s", urlConsulta, chave, ambiente);
    }

    @Deprecated
    public static String getCodeQRCodeContingencia(String chave, String ambiente, String dhEmi, String valorNF, String digVal, String idToken, String CSC, String urlConsulta) throws NoSuchAlgorithmException {
        StringBuilder value = new StringBuilder();
        value.append(chave);
        value.append("|").append("2");
        value.append("|").append(ambiente);
        value.append("|").append(dhEmi, 8, 10);
        value.append("|").append(valorNF);
        value.append("|").append(NFCeUtil.getHexa(digVal));
        value.append("|").append(Integer.valueOf(idToken));
        String cHashQRCode = NFCeUtil.getHexa(NFCeUtil.getHash(value.toString() + CSC)).toUpperCase();
        return urlConsulta + "?p=" + value + "|" + cHashQRCode;
    }

    public static String getCodeQRCodeContingenciaV3(String chave, String ambiente, String dhEmi, String valorNF, String tpDestinatario, String identDest, String urlConsulta, Certificado certificado) throws NfeException {
        String valor = String.format("%s|3|%s|%s|%s|%s|%s", chave, ambiente, dhEmi.substring(8, 10), valorNF, Optional.ofNullable(tpDestinatario).orElse(""), Optional.ofNullable(identDest).orElse(""));
        String assinatura = NFCeUtil.assinarQrCodeV3(valor, certificado);
        return urlConsulta + "?p=" + valor + "|" + assinatura;
    }

    public static byte[] geraHashCSRT(String chave, String csrt) throws NoSuchAlgorithmException {
        ObjetoUtil.verifica(chave).orElseThrow(() -> new InvalidParameterException("Chave n\u00e3o deve ser nula ou vazia"));
        ObjetoUtil.verifica(csrt).orElseThrow(() -> new InvalidParameterException("CSRT n\u00e3o deve ser nulo ou vazio"));
        if (chave.length() != 44) {
            throw new InvalidParameterException("Chave deve conter 44 caracteres.");
        }
        return NFCeUtil.getHash(csrt + chave);
    }

    private static byte[] getHash(String valor) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(valor.getBytes());
        return md.digest();
    }

    private static String getHexa(String valor) {
        return NFCeUtil.getHexa(valor.getBytes());
    }

    private static String getHexa(byte[] bytes) {
        StringBuilder s = new StringBuilder();
        for (byte aByte : bytes) {
            int parteAlta = (aByte >> 4 & 0xF) << 4;
            int parteBaixa = aByte & 0xF;
            if (parteAlta == 0) {
                s.append('0');
            }
            s.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return s.toString();
    }

    private static String assinarQrCodeV3(String dados, Certificado certificado) throws NfeException {
        try {
            KeyStore keyStore = CertificadoService.getKeyStore((Certificado)certificado);
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(certificado.getNome(), new KeyStore.PasswordProtection(ObjetoUtil.verifica(certificado.getSenha()).orElse("").toCharArray()));
            PrivateKey privateKey = pkEntry.getPrivateKey();
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            signature.update(dados.getBytes(StandardCharsets.UTF_8));
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (Exception e) {
            throw new NfeException("Erro ao gerar assinatura do QRCode V3: " + e.getMessage(), e);
        }
    }
}

