/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.AmbienteEnum;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.EstadosEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class WebServiceUtil {
    @Generated
    private static final Logger log = Logger.getLogger(WebServiceUtil.class.getName());
    private static final Pattern sectionPattern = Pattern.compile("^\\[(.+)\\]$");

    private static String getIniValueIgnoreCase(Map<String, String> sectionMap, String targetKey) {
        if (sectionMap == null || sectionMap.isEmpty() || targetKey == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : sectionMap.entrySet()) {
            String keyFromIni = entry.getKey();
            String normalizedKeyFromIni = keyFromIni.replace("..", ".");
            String normalizedTargetKey = targetKey.replace("..", ".");
            if (!normalizedTargetKey.equalsIgnoreCase(normalizedKeyFromIni)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Map<String, Map<String, String>> parseIniFile(InputStream inputStream) throws IOException, NfeException {
        HashMap<String, Map<String, String>> iniData = new HashMap<String, Map<String, String>>();
        String currentSectionName = null;
        HashMap<String, String> currentSectionMap = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith(";") || line.startsWith("#")) continue;
                Matcher sectionMatcher = sectionPattern.matcher(line);
                if (sectionMatcher.matches()) {
                    currentSectionName = sectionMatcher.group(1).trim();
                    if (currentSectionName.isEmpty()) {
                        throw new NfeException("Nome da se\u00e7\u00e3o inv\u00e1lido (vazio) no arquivo INI.");
                    }
                    currentSectionMap = new HashMap<String, String>();
                    iniData.put(currentSectionName, currentSectionMap);
                    continue;
                }
                if (currentSectionName == null) {
                    throw new NfeException("Propriedade encontrada fora de uma se\u00e7\u00e3o: " + line);
                }
                int separatorPos = line.indexOf(61);
                if (separatorPos != -1) {
                    String key = line.substring(0, separatorPos).trim();
                    String value = line.substring(separatorPos + 1).trim();
                    if (!key.isEmpty()) {
                        currentSectionMap.put(key, value);
                        continue;
                    }
                    log.warning("Linha malformada (chave vazia): " + line);
                    continue;
                }
                log.warning("Linha malformada ignorada: " + line);
            }
        }
        return iniData;
    }

    public static String getUrl(ConfiguracoesNfe config, DocumentoEnum tipoDocumento, ServicosEnum tipoServico) throws NfeException {
        String finalUrl;
        Map<String, String> nationalSectionMap;
        String initialSecaoKey;
        Map<String, Map<String, String>> iniData;
        InputStream is = null;
        try {
            if (ObjetoUtil.verifica(config.getArquivoWebService()).isPresent()) {
                File arquivo = new File(config.getArquivoWebService());
                if (!arquivo.exists()) {
                    throw new FileNotFoundException("Arquivo WebService " + config.getArquivoWebService() + " n\u00e3o encontrado");
                }
                is = new FileInputStream(arquivo);
                log.info("[ARQUIVO INI CUSTOMIZADO]: " + config.getArquivoWebService());
            } else {
                is = WebServiceUtil.class.getResourceAsStream("/WebServicesNfe.ini");
                if (is == null) {
                    throw new NfeException("Arquivo WebServicesNfe.ini n\u00e3o encontrado no classpath.");
                }
            }
            iniData = WebServiceUtil.parseIniFile(is);
        }
        catch (IOException e) {
            throw new NfeException("Erro ao carregar arquivo de configura\u00e7\u00e3o WebService: " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.fine("Erro ao fechar InputStream: " + e.getMessage());
                }
            }
        }
        String lookupSectionKey = initialSecaoKey = tipoDocumento.getTipo() + "_" + (Object)((Object)config.getEstado()) + "_" + (config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "H" : "P");
        Map<String, String> initialSectionMap = iniData.get(initialSecaoKey);
        String usarValue = WebServiceUtil.getIniValueIgnoreCase(initialSectionMap, "Usar");
        if (WebServiceUtil.verificaEstadosConsultaCadastro(config, tipoServico)) {
            throw new NfeException("Estado n\u00e3o possui Consulta Cadastro.");
        }
        if (WebServiceUtil.verificaServicosAmbienteNacional(tipoServico)) {
            lookupSectionKey = config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "NFe_AN_H" : "NFe_AN_P";
            nationalSectionMap = iniData.get(lookupSectionKey);
            finalUrl = WebServiceUtil.getIniValueIgnoreCase(nationalSectionMap, tipoServico.getServico());
        } else if (WebServiceUtil.verificaServicosAmbienteSVRS(tipoServico, tipoDocumento)) {
            lookupSectionKey = config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "NFe_SVRS_H" : "NFe_SVRS_P";
            nationalSectionMap = iniData.get(lookupSectionKey);
            finalUrl = WebServiceUtil.getIniValueIgnoreCase(nationalSectionMap, tipoServico.getServico());
        } else if (WebServiceUtil.verificaSeContingenciaSvcNfe(config, tipoDocumento, tipoServico)) {
            lookupSectionKey = WebServiceUtil.verificaEstadosComServidorProprio(config) ? tipoDocumento.getTipo() + "_SVRS_" + (config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "H" : "P") : tipoDocumento.getTipo() + "_SVC-AN_" + (config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "H" : "P");
            Map<String, String> svcSectionMap = iniData.get(lookupSectionKey);
            finalUrl = WebServiceUtil.getIniValueIgnoreCase(svcSectionMap, tipoServico.getServico());
        } else if (ObjetoUtil.verifica(usarValue).isPresent() && !tipoServico.equals((Object)ServicosEnum.URL_CONSULTANFCE) && !tipoServico.equals((Object)ServicosEnum.URL_QRCODE)) {
            lookupSectionKey = usarValue;
            Map<String, String> usarRedirectedSectionMap = iniData.get(lookupSectionKey);
            finalUrl = WebServiceUtil.getIniValueIgnoreCase(usarRedirectedSectionMap, tipoServico.getServico());
        } else {
            Map<String, String> currentSectionMap = iniData.get(lookupSectionKey);
            finalUrl = WebServiceUtil.getIniValueIgnoreCase(currentSectionMap, tipoServico.getServico());
        }
        String finalLookupSectionKeyForLambda = lookupSectionKey;
        ObjetoUtil.verifica(finalUrl).orElseThrow(() -> new NfeException("WebService de " + (Object)((Object)tipoServico) + " n\u00e3o encontrado para " + config.getEstado().getNome() + " na se\u00e7\u00e3o " + finalLookupSectionKeyForLambda));
        log.info("[URL]: " + (Object)((Object)tipoServico) + ": " + finalUrl);
        return finalUrl;
    }

    public static String getCustomUrl(ConfiguracoesNfe config, String section, String key) throws NfeException {
        Map<String, Map<String, String>> iniData;
        InputStream is = null;
        try {
            if (ObjetoUtil.verifica(config.getArquivoWebService()).isPresent()) {
                File arquivo = new File(config.getArquivoWebService());
                if (!arquivo.exists()) {
                    throw new FileNotFoundException("Arquivo WebService " + config.getArquivoWebService() + " n\u00e3o encontrado");
                }
                is = Files.newInputStream(arquivo.toPath(), new OpenOption[0]);
                log.info("[ARQUIVO INI CUSTOMIZADO]: " + config.getArquivoWebService());
            } else {
                is = WebServiceUtil.class.getResourceAsStream("/WebServicesNfe.ini");
                if (is == null) {
                    throw new NfeException("Arquivo WebServicesNfe.ini n\u00e3o encontrado no classpath.");
                }
            }
            iniData = WebServiceUtil.parseIniFile(is);
        }
        catch (IOException e) {
            throw new NfeException("Erro ao carregar arquivo de configura\u00e7\u00e3o WebService: " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.fine("Erro ao fechar InputStream: " + e.getMessage());
                }
            }
        }
        Map<String, String> sectionMap = iniData.get(section);
        if (sectionMap == null) {
            throw new NfeException("Se\u00e7\u00e3o '" + section + "' n\u00e3o encontrada em WebServicesNfe.ini");
        }
        String value = WebServiceUtil.getIniValueIgnoreCase(sectionMap, key);
        if (value == null || value.trim().isEmpty()) {
            throw new NfeException("Chave '" + key + "' n\u00e3o encontrada na se\u00e7\u00e3o '" + section + "' do WebServicesNfe.ini");
        }
        log.info("[URL CUSTOM] " + section + " -> " + key + ": " + value);
        return value;
    }

    private static boolean verificaSeContingenciaSvcNfe(ConfiguracoesNfe config, DocumentoEnum tipoDocumento, ServicosEnum tipoServico) {
        return !tipoServico.equals((Object)ServicosEnum.URL_CONSULTANFCE) && !tipoServico.equals((Object)ServicosEnum.URL_QRCODE) && config.isContigenciaSVC() && tipoDocumento.equals((Object)DocumentoEnum.NFE);
    }

    private static boolean verificaEstadosComServidorProprio(ConfiguracoesNfe config) {
        return config.getEstado().equals((Object)EstadosEnum.GO) || config.getEstado().equals((Object)EstadosEnum.AM) || config.getEstado().equals((Object)EstadosEnum.BA) || config.getEstado().equals((Object)EstadosEnum.MA) || config.getEstado().equals((Object)EstadosEnum.MS) || config.getEstado().equals((Object)EstadosEnum.MT) || config.getEstado().equals((Object)EstadosEnum.PE) || config.getEstado().equals((Object)EstadosEnum.PR);
    }

    private static boolean verificaServicosAmbienteNacional(ServicosEnum tipoServico) {
        return tipoServico.equals((Object)ServicosEnum.DISTRIBUICAO_DFE) || tipoServico.equals((Object)ServicosEnum.MANIFESTACAO) || tipoServico.equals((Object)ServicosEnum.EPEC);
    }

    private static boolean verificaServicosAmbienteSVRS(ServicosEnum tipoServico, DocumentoEnum tipoDocumento) {
        return tipoDocumento.equals((Object)DocumentoEnum.NFE) && (tipoServico.equals((Object)ServicosEnum.ECONF) || tipoServico.equals((Object)ServicosEnum.EVENTO_GENERICO) || tipoServico.equals((Object)ServicosEnum.CANC_ECONF));
    }

    private static boolean verificaEstadosConsultaCadastro(ConfiguracoesNfe config, ServicosEnum tipoServico) {
        return tipoServico.equals((Object)ServicosEnum.CONSULTA_CADASTRO) && (config.getEstado().equals((Object)EstadosEnum.PA) || config.getEstado().equals((Object)EstadosEnum.AL) || config.getEstado().equals((Object)EstadosEnum.AP) || config.getEstado().equals((Object)EstadosEnum.DF) || config.getEstado().equals((Object)EstadosEnum.PI) || config.getEstado().equals((Object)EstadosEnum.RJ) || config.getEstado().equals((Object)EstadosEnum.RO) || config.getEstado().equals((Object)EstadosEnum.SE) || config.getEstado().equals((Object)EstadosEnum.TO));
    }
}

