/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.clisitef.tef;

import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.swconsultoria.clisitef.dom.RetornoSitef;
import br.com.swconsultoria.clisitef.enums.Funcoes;
import br.com.swconsultoria.clisitef.exception.TefException;
import br.com.swconsultoria.clisitef.tef.ConfiguracoesTef;
import br.com.swconsultoria.clisitef.util.RetornoUtil;

public class FuncoesPinPad {
    public static boolean verificaPinPad() throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            int resposta = cliSiTefI.verificaPresencaPinPad();
            return resposta == 1;
        }
        catch (TefException e) {
            throw new TefException("Erro ao verificar PinPad: " + e.getMessage());
        }
    }

    public static void mensagemPermanentePinPad(String mensagem) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            cliSiTefI.escreveMensagemPermanentePinPad(mensagem);
        }
        catch (TefException e) {
            throw new TefException("Erro ao adicionar mensagem ao PinPad: " + e.getMessage());
        }
    }

    public static RetornoSitef leTrilha3(String mensagem) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            int status = cliSiTefI.leTrilha3(mensagem);
            if (RetornoUtil.continua(status)) {
                return RetornoUtil.getRetorno(cliSiTefI);
            }
            RetornoSitef retornoSitef = new RetornoSitef();
            retornoSitef.setContinua(false);
            return retornoSitef;
        }
        catch (TefException e) {
            throw new TefException("Erro ao ler cart\u00e3o: " + e.getMessage());
        }
    }

    public static boolean leSimNaoPinPad(String mensagem) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            int status = cliSiTefI.leSimNaoPinPad(mensagem);
            return status == 1;
        }
        catch (TefException e) {
            throw new TefException("Erro : " + e.getMessage());
        }
    }

    public static String obtemInformacoes() throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            int status = cliSiTefI.obtemInformacoesPinPad();
            if (status == 0) {
                return cliSiTefI.getDadosSaida();
            }
            throw new TefException("Erro ao capturar informa\u00e7\u00f5es do PinPad.");
        }
        catch (TefException e) {
            throw new TefException("Erro : " + e.getMessage());
        }
    }

    public static void cargaDeTabelas(Funcoes tipoCarga) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            cliSiTefI.setModalidade(tipoCarga.getCodigo());
            int n = cliSiTefI.iniciaFuncaoSiTefInterativo();
        }
        catch (TefException e) {
            throw new TefException("Erro : " + e.getMessage());
        }
    }
}

