/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.clisitef.util;

import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.swconsultoria.clisitef.dom.RetornoSitef;
import br.com.swconsultoria.clisitef.enums.TipoCampo;
import br.com.swconsultoria.clisitef.enums.TipoRetorno;
import br.com.swconsultoria.clisitef.exception.TefException;

public class RetornoUtil {
    public static RetornoSitef getRetorno(JCliSiTefI cliSiTefI) throws TefException {
        RetornoSitef retornoSitef = new RetornoSitef();
        retornoSitef.setTamanhoMinimo(cliSiTefI.getTamanhoMinimo());
        retornoSitef.setTamanhoMaximo(cliSiTefI.getTamanhoMaximo());
        switch (cliSiTefI.getProximoComando()) {
            case 0: {
                retornoSitef.setTipoCampo(TipoCampo.getTipoCampo(cliSiTefI.getTipoCampo()));
                if (retornoSitef.getTipoCampo().equals((Object)TipoCampo.DESCONHECIDO)) {
                    retornoSitef.setBuffer(cliSiTefI.getTipoCampo() + " - " + cliSiTefI.getBuffer());
                } else {
                    retornoSitef.setBuffer(cliSiTefI.getBuffer());
                }
                retornoSitef.setTipoRetorno(TipoRetorno.SALVAR_INFORMACAO);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 1: 
            case 2: 
            case 3: {
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setTipoRetorno(TipoRetorno.MSG);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 4: {
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setTipoRetorno(TipoRetorno.TITULO_MENU);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 11: 
            case 12: 
            case 13: {
                retornoSitef.setTipoRetorno(TipoRetorno.APAGAR_TEXTO);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 14: {
                retornoSitef.setTipoRetorno(TipoRetorno.APAGAR_TITULO);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 20: {
                retornoSitef.setContinua(true);
                retornoSitef.setTipoRetorno(TipoRetorno.MENU_SIM_NAO);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                return retornoSitef;
            }
            case 21: {
                retornoSitef.setContinua(true);
                retornoSitef.setTipoRetorno(TipoRetorno.MENU_OPCOES);
                retornoSitef.setOpcoes(cliSiTefI.getBuffer().split(";"));
                return retornoSitef;
            }
            case 22: {
                retornoSitef.setTipoRetorno(TipoRetorno.MSG_OK);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 23: {
                retornoSitef.setTipoRetorno(TipoRetorno.AGUARDAR);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 30: {
                retornoSitef.setTipoCampo(TipoCampo.getTipoCampo(cliSiTefI.getTipoCampo()));
                retornoSitef.setTipoRetorno(TipoRetorno.PEGAR_INFORMACAO);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 34: {
                retornoSitef.setTipoRetorno(TipoRetorno.PEGAR_INFORMACAO_MONETARIA);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 50: {
                retornoSitef.setTipoRetorno(TipoRetorno.EXIBIR_QRCODE);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 51: {
                retornoSitef.setTipoRetorno(TipoRetorno.REMOVER_QRCODE);
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
            case 52: {
                retornoSitef.setTipoRetorno(TipoRetorno.MSG_RODAPE);
                retornoSitef.setBuffer(cliSiTefI.getBuffer());
                retornoSitef.setContinua(true);
                return retornoSitef;
            }
        }
        throw new TefException("Comando n\u00e3o reconhecido: " + cliSiTefI.getProximoComando());
    }

    public static boolean continua(int retorno) throws TefException {
        if (retorno < 0) {
            throw new TefException(RetornoUtil.validaErro(retorno));
        }
        return retorno == 10000;
    }

    public static String validaErro(int retorno) {
        switch (retorno) {
            case -1: {
                return "M\u00f3dulo n\u00e3o inicializado. O PDV tentou chamar alguma rotina sem antes executar a fun\u00e7\u00e3o configura.";
            }
            case -2: {
                return "Opera\u00e7\u00e3o cancelada pelo operador.";
            }
            case -3: {
                return "O par\u00e2metro fun\u00e7\u00e3o / modalidade \u00e9 inv\u00e1lido.";
            }
            case -4: {
                return "Falta de mem\u00f3ria no PDV.";
            }
            case -5: {
                return "Sem conex\u00e3o SiTef";
            }
            case -6: {
                return "Opera\u00e7\u00e3o cancelada pelo usu\u00e1rio (no pinpad).";
            }
            case -7: {
                return "Reservado";
            }
            case -8: {
                return "A CliSiTef n\u00e3o possui a implementa\u00e7\u00e3o da fun\u00e7\u00e3o necess\u00e1ria, provavelmente est\u00e1 desatualizada (a CliSiTefI \u00e9 mais recente).";
            }
            case -9: {
                return "A automa\u00e7\u00e3o chamou a rotina ContinuaFuncaoSiTefInterativo sem antes iniciar uma fun\u00e7\u00e3o iterativa.";
            }
            case -10: {
                return "Algum par\u00e2metro obrigat\u00f3rio n\u00e3o foi passado pela automa\u00e7\u00e3o comercial.";
            }
            case -12: {
                return "Erro na execu\u00e7\u00e3o da rotina iterativa. Provavelmente o processo iterativo anterior n\u00e3o foi finalizado at\u00e9 o final (enquanto o retorno for igual a 10000).";
            }
            case -13: {
                return "Erro na fun\u00e7\u00e3o ObtemQuantidadeTransa\u00e7\u00f5esPendentes, quando o n\u00famero do cupom passado \u00e9 diferente do cupom de venda atual.";
            }
            case -15: {
                return "Opera\u00e7\u00e3o cancelada pela automa\u00e7\u00e3o comercial.";
            }
            case -20: {
                return "Par\u00e2metro inv\u00e1lido passado para a fun\u00e7\u00e3o.";
            }
            case -21: {
                return "Utilizada uma palavra proibida, por exemplo SENHA, para coletar dados em aberto no pinpad. Por exemplo na fun\u00e7\u00e3o ObtemDadoPinpadDiretoEx.";
            }
            case -25: {
                return "Erro no Correspondente banc\u00e1rio: Deve realizar sangria.";
            }
            case -30: {
                return "Erro de acesso ao arquivo. Certifique-se que o usu\u00e1rio que roda a aplica\u00e7\u00e3o tem direitos de leitura/escrita.";
            }
            case -40: {
                return "Transa\u00e7\u00e3o negada pelo SiTef.";
            }
            case -41: {
                return "Dados inv\u00e1lidos.";
            }
            case -42: {
                return "Reservado";
            }
            case -43: {
                return "Problema na execu\u00e7\u00e3o de alguma das rotinas no pinpad.";
            }
            case -50: {
                return "Transa\u00e7\u00e3o n\u00e3o segura.";
            }
            case -100: {
                return "Erro interno do m\u00f3dulo.";
            }
        }
        return "Erros detectados internamente pela rotina.";
    }
}

