/*
 * Decompiled with CFR 0.152.
 */
package jnafilechooser.demo;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jnafilechooser.win32.Comdlg32;
import jnafilechooser.win32.Ole32;
import jnafilechooser.win32.Shell32;

public class PlumbingDemo {
    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        final JFrame frame = new JFrame(PlumbingDemo.class.getName());
        JButton chooseFolder = new JButton("Choose Folder");
        JPanel content = new JPanel(new FlowLayout(1, 8, 8));
        frame.setContentPane(content);
        content.add(chooseFolder);
        chooseFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ole32.OleInitialize(null);
                Shell32.BrowseInfo params = new Shell32.BrowseInfo();
                params.hwndOwner = Native.getWindowPointer((Window)frame);
                params.ulFlags = 81;
                Pointer pidl = Shell32.SHBrowseForFolder((Shell32.BrowseInfo)params);
                if (pidl != null) {
                    Memory path = new Memory(260L);
                    path.clear(260L);
                    Shell32.SHGetPathFromIDListW((Pointer)pidl, (Pointer)path);
                    String pathStr = path.getWideString(0L);
                    System.out.println(pathStr);
                }
                Ole32.CoTaskMemFree((Pointer)pidl);
            }
        });
        JButton chooseFile = new JButton("Choose File");
        content.add(chooseFile);
        chooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
                params.hwndOwner = Native.getWindowPointer((Window)frame);
                params.nMaxFile = 260;
                params.lpstrFile = new Memory(260L);
                params.lpstrFile.clear(260L);
                String filterStr = "All Files\u0000*.*\u0000Text Files\u0000*.txt;*.log\u0000Pictures\u0000*.png;*.jpg;*.bmp;*.gif\u0000\u0000";
                params.lpstrFilter = new WString(filterStr);
                params.lpstrCustomFilter = null;
                params.nFilterIndex = 1;
                params.Flags = 0x88000C;
                if (Comdlg32.GetOpenFileNameW((Comdlg32.OpenFileName)params)) {
                    System.out.println(params.lpstrFile.getWideString(0L));
                } else {
                    int err = Comdlg32.CommDlgExtendedError();
                    System.out.println(err);
                }
            }
        });
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

