/*
 * Decompiled with CFR 0.152.
 */
package jnafilechooser.demo;

import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jnafilechooser.api.JnaFileChooser;
import net.miginfocom.swing.MigLayout;

public class PortablePorcelainDemo {
    public static void main(String[] args) throws Exception {
        if (Platform.isWindows()) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        final JCheckBox enableMultiSelect = new JCheckBox();
        final JComboBox<JnaFileChooser.Mode> selectionMode = new JComboBox<JnaFileChooser.Mode>(JnaFileChooser.Mode.values());
        final JComboBox<String> dialogType = new JComboBox<String>(new String[]{"Open", "Save"});
        final JCheckBox useFilter = new JCheckBox();
        JButton choose = new JButton("Choose");
        final JFrame frame = new JFrame(PortablePorcelainDemo.class.getName());
        choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JnaFileChooser fc = new JnaFileChooser();
                fc.setTitle("Portable");
                fc.setMultiSelectionEnabled(enableMultiSelect.isSelected());
                fc.setMode((JnaFileChooser.Mode)selectionMode.getSelectedItem());
                if (useFilter.isSelected()) {
                    fc.addFilter("All Files", new String[]{"*"});
                    fc.addFilter("Pictures", new String[]{"jpg", "jpeg", "gif", "png", "bmp"});
                    fc.addFilter("Text files", new String[]{"txt", "log", "xml"});
                }
                boolean result = false;
                result = dialogType.getSelectedItem().equals("Open") ? fc.showOpenDialog((Window)frame) : fc.showSaveDialog((Window)frame);
                if (result) {
                    JOptionPane.showMessageDialog(frame, fc.getSelectedFiles(), "Selection", 1);
                }
            }
        });
        JPanel content = new JPanel((LayoutManager)new MigLayout("", "[right][left]"));
        content.add(new JLabel("Enable multiselect:"));
        content.add((Component)enableMultiSelect, "wrap");
        content.add(new JLabel("Use filter:"));
        content.add((Component)useFilter, "wrap");
        content.add(new JLabel("Selection mode:"));
        content.add(selectionMode, "wrap");
        content.add(new JLabel("Dialog type:"));
        content.add(dialogType, "wrap");
        content.add((Component)choose, "span 2, gaptop 8, align center");
        frame.setContentPane(content);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

