/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class PagingModel
extends AbstractTableModel {
    protected int pageSize;
    protected int pageOffset;
    protected Record[] data;

    public PagingModel() {
        this(10000, 100);
    }

    public PagingModel(int numRows, int size) {
        this.data = new Record[numRows];
        this.pageSize = size;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new Record();
        }
    }

    @Override
    public int getRowCount() {
        return Math.min(this.pageSize, this.data.length);
    }

    @Override
    public int getColumnCount() {
        return Record.getColumnCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        int realRow = row + this.pageOffset * this.pageSize;
        return this.data[realRow].getValueAt(col);
    }

    @Override
    public String getColumnName(int col) {
        return Record.getColumnName(col);
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this.data.length / (double)this.pageSize);
    }

    public int getRealRowCount() {
        return this.data.length;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int s) {
        if (s == this.pageSize) {
            return;
        }
        int oldPageSize = this.pageSize;
        this.pageSize = s;
        this.pageOffset = oldPageSize * this.pageOffset / this.pageSize;
        this.fireTableDataChanged();
    }

    public void pageDown() {
        if (this.pageOffset < this.getPageCount() - 1) {
            ++this.pageOffset;
            this.fireTableDataChanged();
        }
    }

    public void pageUp() {
        if (this.pageOffset > 0) {
            --this.pageOffset;
            this.fireTableDataChanged();
        }
    }

    public static JScrollPane createPagingScrollPaneForTable(JTable jt) {
        JScrollPane jsp = new JScrollPane(jt);
        TableModel tmodel = jt.getModel();
        if (!(tmodel instanceof PagingModel)) {
            return jsp;
        }
        final PagingModel model = (PagingModel)tmodel;
        final JButton upButton = new JButton(new ArrowIcon(0));
        upButton.setEnabled(false);
        final JButton downButton = new JButton(new ArrowIcon(1));
        if (model.getPageCount() <= 1) {
            downButton.setEnabled(false);
        }
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                model.pageUp();
                if (model.getPageOffset() == 0) {
                    upButton.setEnabled(false);
                }
                downButton.setEnabled(true);
            }
        });
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                model.pageDown();
                if (model.getPageOffset() == model.getPageCount() - 1) {
                    downButton.setEnabled(false);
                }
                upButton.setEnabled(true);
            }
        });
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(32);
        jsp.setCorner("UPPER_RIGHT_CORNER", upButton);
        jsp.setCorner("LOWER_RIGHT_CORNER", downButton);
        return jsp;
    }
}

