/*
 * Decompiled with CFR 0.152.
 */
package com.towel.cache;

import com.towel.el.FieldResolver;
import com.towel.el.annotation.AnnotationResolver;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class FormatterCache {
    private static final Map<Class<?>, Map<String, Reference<FieldResolver>>> RESOLVERS = new WeakHashMap();

    private FormatterCache() {
    }

    public static FieldResolver getResolver(Class<?> clazz, String resolverName) {
        FieldResolver result;
        WeakReference<FieldResolver> resolver;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Reference<FieldResolver>> clazzMap = RESOLVERS.get(clazz);
        if (clazzMap == null) {
            clazzMap = new WeakHashMap<String, Reference<FieldResolver>>();
            RESOLVERS.put(clazz, clazzMap);
        }
        if ((resolver = (WeakReference<FieldResolver>)clazzMap.get(resolverName)) == null) {
            resolver = new WeakReference<FieldResolver>(new AnnotationResolver(clazz).resolveSingle(resolverName));
            clazzMap.put(resolverName, resolver);
        }
        if ((result = (FieldResolver)resolver.get()) == null) {
            clazzMap.put(resolverName, new WeakReference<FieldResolver>(new AnnotationResolver(clazz).resolveSingle(resolverName)));
        }
        return result;
    }
}

