/*
 * Decompiled with CFR 0.152.
 */
package com.towel.reflec;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClassIntrospector {
    private Class<?> clazz;

    public ClassIntrospector(Class<?> clazz2) {
        this.clazz = clazz2;
    }

    public <E extends Annotation> List<AnnotatedElement<Field, E>> getAnnotatedFields(Class<E> ann) {
        Field[] fields;
        ArrayList<AnnotatedElement<Field, AnnotatedElement<Field, E>>> list = new ArrayList<AnnotatedElement<Field, AnnotatedElement<Field, E>>>();
        for (Field f : fields = this.clazz.getFields()) {
            if (!f.isAnnotationPresent(ann)) continue;
            list.add(new AnnotatedElement<Field, E>(f, f.getAnnotation(ann)));
        }
        return list;
    }

    public <E extends Annotation> List<AnnotatedElement<Field, E>> getAnnotatedDeclaredFields(Class<E> ann) {
        Field[] declaredFields;
        ArrayList<AnnotatedElement<Field, AnnotatedElement<Field, E>>> list = new ArrayList<AnnotatedElement<Field, AnnotatedElement<Field, E>>>();
        for (Field f : declaredFields = this.clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(ann)) continue;
            list.add(new AnnotatedElement<Field, E>(f, f.getAnnotation(ann)));
        }
        return list;
    }

    public <E extends Annotation> List<AnnotatedElement<Method, E>> getAnnotatedDeclaredMethods(Class<E> ann) {
        Method[] declaredMethods;
        ArrayList<AnnotatedElement<Method, AnnotatedElement<Method, E>>> list = new ArrayList<AnnotatedElement<Method, AnnotatedElement<Method, E>>>();
        for (Method f : declaredMethods = this.clazz.getDeclaredMethods()) {
            if (!f.isAnnotationPresent(ann)) continue;
            list.add(new AnnotatedElement<Method, E>(f, f.getAnnotation(ann)));
        }
        return list;
    }

    public <E extends Annotation> List<AnnotatedElement<Method, E>> getAnnotatedMethods(Class<E> ann) {
        Method[] methods;
        ArrayList<AnnotatedElement<Method, AnnotatedElement<Method, E>>> list = new ArrayList<AnnotatedElement<Method, AnnotatedElement<Method, E>>>();
        for (Method f : methods = this.clazz.getMethods()) {
            if (!f.isAnnotationPresent(ann)) continue;
            list.add(new AnnotatedElement<Method, E>(f, f.getAnnotation(ann)));
        }
        return list;
    }

    public Class<?> getMethodReturnClass(String string, Class<?> arg) {
        try {
            return this.clazz.getDeclaredMethod(string, arg).getReturnType();
        }
        catch (Exception e) {
            return String.class;
        }
    }

    public Field getField(String fieldName) throws NoSuchFieldException {
        try {
            Field f = this.clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return this.getField(fieldName, this.clazz.getSuperclass());
        }
    }

    private Field getField(String fieldName, Class<?> clazz2) throws NoSuchFieldException {
        if (clazz2 == null) {
            throw new NoSuchFieldException();
        }
        try {
            Field f = clazz2.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return this.getField(fieldName, clazz2.getSuperclass());
        }
    }

    public static class AnnotatedElement<T, K extends Annotation> {
        private K annotation;
        private T comp;

        public AnnotatedElement(T t, K k) {
            this.comp = t;
            this.annotation = k;
        }

        public T getElement() {
            return this.comp;
        }

        public K getAnnotation() {
            return this.annotation;
        }
    }
}

