/*
 * Decompiled with CFR 0.152.
 */
package com.towel.sound;

import com.towel.sound.Streamed;
import java.io.InputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class PlayingStreamed
implements Runnable {
    private volatile boolean isFinished = false;
    private volatile boolean isPaused = false;
    private Streamed stream;

    PlayingStreamed(Streamed stream2) {
        this.stream = stream2;
    }

    public void setPaused(boolean pause) {
        this.isPaused = pause;
    }

    public void stop() {
        this.isFinished = true;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    private SourceDataLine createDataLine(int bufferSize) throws LineUnavailableException {
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, this.stream.getFormat()));
        line.open(this.stream.getFormat(), bufferSize);
        return line;
    }

    private byte[] createStreamedBuffer() {
        return new byte[this.stream.getFormat().getFrameSize() * Math.round(this.stream.getFormat().getSampleRate() / 10.0f)];
    }

    @Override
    public void run() {
        if (this.isFinished) {
            throw new IllegalStateException("Sound already played.");
        }
        Object line = null;
        try {
            byte[] buffer = this.createStreamedBuffer();
            SourceDataLine line2 = this.createDataLine(buffer.length);
            InputStream input = this.stream.newInputStream();
            line2.start();
            int numBytesRead = 0;
            while (numBytesRead != -1 && !this.isFinished()) {
                if (this.isPaused()) {
                    Thread.yield();
                    continue;
                }
                numBytesRead = input.read(buffer, 0, buffer.length);
                if (numBytesRead == -1) continue;
                line2.write(buffer, 0, numBytesRead);
            }
            this.stop();
            if (line2 != null) {
                line2.drain();
                line2.close();
            }
        }
        catch (Exception e) {
        }
        finally {
            this.stop();
        }
    }

    public Streamed getStream() {
        return this.stream;
    }
}

