/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.calendar;

import com.towel.awt.ann.Action;
import com.towel.awt.ann.ActionManager;
import com.towel.swing.calendar.DatePicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class CalendarView
extends JPanel {
    @Action(method="openPopup")
    private JButton button;
    private DatePicker datePicker;
    private JTextField editor;
    private String lastValidString;
    private JPopupMenu popup;

    public CalendarView() {
        this(null, null);
    }

    public CalendarView(String pattern) {
        this(null, new SimpleDateFormat(pattern));
    }

    public CalendarView(Locale locale, DateFormat format) {
        this.datePicker = new DatePicker(locale, format);
        this.datePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if ("day".equals(prop) || "date".equals(prop)) {
                    CalendarView.this.dateSelected(CalendarView.this.datePicker.getDate());
                }
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(this.datePicker);
        this.lastValidString = "";
        this.init();
        new ActionManager(this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getEditor(), "Center");
        this.add((Component)this.getButton(), "East");
    }

    private JTextField getEditor() {
        if (this.editor == null) {
            this.editor = new JTextField(10);
            this.editor.setInputVerifier(new DateInputVerifier(this, null));
        }
        return this.editor;
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = new JButton(". .");
            this.button.setMargin(new Insets(0, 5, 0, 5));
        }
        return this.button;
    }

    public void setText(String text) {
        this.getEditor().setText(text);
        this.commitEdit();
    }

    public String getText() {
        return this.getEditor().getText();
    }

    public void setIcon(Icon icon) {
        this.getButton().setIcon(icon);
        if (icon == null) {
            this.getButton().setText(". .");
        } else {
            this.getButton().setText("");
        }
    }

    public Calendar getSelectedDate() {
        if (this.getText().length() > 0) {
            return this.datePicker.getSelectedDate();
        }
        return null;
    }

    public void setSelectedDate(Calendar calendar) {
        this.datePicker.setSelectedDate(calendar);
    }

    @Override
    public Locale getLocale() {
        return this.datePicker.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.datePicker.setLocale(locale);
    }

    public DateFormat getDateFormat() {
        return this.datePicker.getDateFormat();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.datePicker.setDateFormat(dateFormat);
        if (this.lastValidString.length() > 0) {
            this.lastValidString = dateFormat.format(this.getSelectedDate().getTime());
        }
        this.commitEdit();
    }

    public void setPattern(String pattern) {
        this.setDateFormat(new SimpleDateFormat(pattern));
    }

    public Color getHeaderBackground() {
        return this.datePicker.getHeaderBackground();
    }

    public void setHeaderBackground(Color headerBackground) {
        this.datePicker.setHeaderBackground(headerBackground);
    }

    public Color getWeekDaysBackground() {
        return this.datePicker.getWeekDaysBackground();
    }

    public void setWeekDaysBackground(Color weekDaysBackground) {
        this.datePicker.setWeekDaysBackground(weekDaysBackground);
    }

    public Color getDayPickerBackground() {
        return this.datePicker.getDayPickerBackground();
    }

    public void setDayPickerBackground(Color dayPickerBackground) {
        this.datePicker.setDayPickerBackground(dayPickerBackground);
    }

    public Color getSelectedDayBackground() {
        return this.datePicker.getSelectedDayBackground();
    }

    public void setSelectedDayBackground(Color selectedDayBackground) {
        this.datePicker.setSelectedDayBackground(selectedDayBackground);
    }

    public Color getHeaderForeground() {
        return this.datePicker.getHeaderForeground();
    }

    public void setHeaderForeground(Color headerForeground) {
        this.datePicker.setHeaderForeground(headerForeground);
    }

    public Color getWeekDaysForeground() {
        return this.datePicker.getWeekDaysForeground();
    }

    public void setWeekDaysForeground(Color weekDaysForeground) {
        this.datePicker.setWeekDaysForeground(weekDaysForeground);
    }

    public Color getDayPickerForeground() {
        return this.datePicker.getDayPickerForeground();
    }

    public void setDayPickerForeground(Color dayPickerForeground) {
        this.datePicker.setDayPickerForeground(dayPickerForeground);
    }

    public Color getSelectedDayForeground() {
        return this.datePicker.getSelectedDayForeground();
    }

    public void setSelectedDayForeground(Color selectedDayForeground) {
        this.datePicker.setSelectedDayForeground(selectedDayForeground);
    }

    public void setTodayString(String todayString) {
        this.datePicker.setTodayString(todayString);
    }

    public void setTodayButtonVisible(boolean visible) {
        this.datePicker.setTodayButtonVisible(visible);
    }

    private void openPopup() {
        this.popup.show(this.button, this.button.getWidth() - this.datePicker.getPreferredSize().width, this.button.getHeight());
    }

    public void dateSelected(String strDate) {
        this.getEditor().setText(strDate);
        this.commitEdit();
        this.popup.setVisible(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getEditor().setEnabled(enabled);
        this.getButton().setEnabled(enabled);
        CalendarView.super.setEnabled(enabled);
    }

    private void commitEdit() {
        String strDate = this.getText();
        if (strDate.isEmpty() || this.isValidDate(strDate)) {
            this.lastValidString = strDate;
        } else {
            this.getEditor().setText(this.lastValidString);
            strDate = this.lastValidString;
        }
        if (strDate.length() > 0) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDateFormat().parse(strDate));
                this.datePicker.setSelectedDate(cal);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isValidDate(String strDate) {
        try {
            this.getDateFormat().parse(strDate);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public class DateInputVerifier
    extends InputVerifier {
        private DateInputVerifier() {
        }

        DateInputVerifier(CalendarView calendarView, DateInputVerifier dateInputVerifier) {
            this();
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            CalendarView.this.commitEdit();
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            String strDate = ((JTextField)input).getText();
            return strDate.isEmpty() || CalendarView.this.isValidDate(strDate);
        }
    }
}

