/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.list;

import com.towel.awt.Action;
import com.towel.awt.ActionManager;
import com.towel.swing.ButtonLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class InfoList
extends JComponent {
    private List<ButtonLabel> labels = new ArrayList<ButtonLabel>();
    private ActionManager manager = new ActionManager();
    private String prefix = "";

    private void updateSize() {
        if (this.labels.size() != 0) {
            this.setPreferredSize(this.getLayout().preferredLayoutSize(this));
        }
    }

    public void setPrefix(String prefix2) {
        String oldPrefix = this.prefix;
        this.prefix = prefix2;
        if (oldPrefix.length() > 0) {
            for (ButtonLabel label : this.labels) {
                label.setText(label.getText().replace(oldPrefix, this.prefix));
            }
        } else {
            for (ButtonLabel label2 : this.labels) {
                label2.setText(String.valueOf(this.prefix) + label2.getText());
            }
        }
        this.updateSize();
    }

    private void replace() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 3));
        for (ButtonLabel label : this.labels) {
            this.add(label);
        }
    }

    public void add(String s) {
        this.labels.add(new ButtonLabel(String.valueOf(this.prefix) + s));
        this.replace();
        this.updateSize();
    }

    public void addAll(Collection<String> coll) {
        for (String s : coll) {
            this.add(s);
        }
        this.updateSize();
    }

    public void remove(String s) {
        int idx = this.indexOf(s);
        if (idx > -1) {
            this.labels.remove(idx);
        }
        this.replace();
        this.updateSize();
    }

    public void removeAll(Collection<String> coll) {
        for (String s : coll) {
            this.remove(s);
        }
        this.updateSize();
    }

    public int indexOf(String item) {
        int idx = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!this.labels.get(i).getText().equals(String.valueOf(this.prefix) + item)) continue;
            idx = i;
        }
        return idx;
    }

    public void addAction(String item, Action action) {
        this.manager.manage(this.labels.get(this.indexOf(item)), action);
    }
}

