/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.table;

import com.towel.collections.paginator.ListPaginator;
import com.towel.collections.paginator.Paginator;
import com.towel.el.FieldResolver;
import com.towel.swing.event.ObjectSelectListener;
import com.towel.swing.event.SelectEvent;
import com.towel.swing.table.ObjectTableModel;
import com.towel.swing.table.SelectTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class OptionTable<T>
implements ActionListener {
    private SelectTable<T> table;
    private List<ObjectSelectListener> listeners;
    private Object selected;
    private List<T> selecteds;
    private Container pane;
    private List<OptionButton> buttons;
    private JPanel bPanel;
    private Paginator<T> data;

    public OptionTable(FieldResolver[] cols, Paginator<T> data) {
        this(cols, data, 0);
    }

    public OptionTable(FieldResolver[] cols, Paginator<T> data, int selectType) {
        this.data = data;
        this.table = new SelectTable(new ObjectTableModel(cols), data, selectType);
        this.listeners = new ArrayList<ObjectSelectListener>();
        this.buttons = new ArrayList<OptionButton>();
        this.table.addObjectSelectListener(e -> {
            if (((SelectTable)e.getSource()).getSelectType() == 0) {
                this.selected = e.getObject();
            } else {
                this.selecteds = (List)e.getObject();
            }
        });
        this.pane = new JPanel();
        JPanel panel = (JPanel)this.pane;
        panel.setLayout(new BorderLayout());
        this.bPanel = new JPanel();
        panel.add((Component)this.table.getContent(), "North");
        panel.add((Component)this.bPanel, "South");
    }

    public OptionTable(FieldResolver[] cols, List<T> data) {
        this(cols, new ListPaginator<T>(data, 25));
    }

    public Container getContent() {
        return this.pane;
    }

    public void addObjectSelectListener(ObjectSelectListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(SelectEvent event) {
        this.listeners.forEach(listener -> listener.notifyObjectSelected(event.clone()));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.table.updateSelectedObject();
        for (OptionButton ot : this.buttons) {
            if (!ot.getButton().equals(arg0.getSource())) continue;
            if (this.table.getSelectType() == 0) {
                this.notifyListeners(new SelectEvent(this, this.selected, ot.getActionId()));
            } else {
                this.notifyListeners(new SelectEvent(this, this.selecteds, ot.getActionId()));
            }
            return;
        }
    }

    public void addOptionButton(OptionButton opButton) {
        this.buttons.add(opButton);
        opButton.getButton().addActionListener(this);
        this.bPanel.removeAll();
        this.buttons.forEach(button -> this.bPanel.add(button.getButton()));
        this.bPanel.revalidate();
    }

    public Paginator<T> getData() {
        return this.data;
    }

    public void reload() {
        this.table.notifyDataChanged();
    }

    public static class OptionButton {
        private int actionId;
        private JButton button;

        public int getActionId() {
            return this.actionId;
        }

        public JButton getButton() {
            return this.button;
        }

        public OptionButton(JButton button, int actionId) {
            this.actionId = actionId;
            this.button = button;
        }
    }
}

