/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.table;

import com.towel.cfg.TowelConfig;
import com.towel.swing.TextUtils;
import com.towel.swing.table.TableFilterWildCard;
import com.towel.swing.table.adapter.TableColumnModelAdapter;
import com.towel.swing.table.headerpopup.HeaderPopupListener;
import com.towel.swing.table.headerpopup.TableHeaderPopup;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TableFilter
extends AbstractTableModel {
    private static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof String) {
                return Collator.getInstance().compare(o1, o2);
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private static final Comparator<Object> LEXICAL_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return Collator.getInstance().compare(o1.toString(), o2.toString());
        }
    };
    private static final int NO_COLUMN = -1;
    private static final String POPUP_CUSTOMIZE_ATTR = "popup_customize_attr";
    private static final String POPUP_EMPTY_ATTR = "popup_empty_attr";
    private static final String POPUP_ITM_ALL_ATTR = "popup_itm_all_attr";
    private static final String POPUP_ITM_SORT_ASC_ATTR = "popup_itm_sort_asc_attr";
    private static final String POPUP_ITM_SORT_DESC_ATTR = "popup_itm_sort_desc_attr";
    private static final String POPUP_TEXT_ATTR = "popup_text";
    private Set<Integer> disableColumns;
    private Map<Integer, List<Integer>> filterByColumn = null;
    private List<Integer> filteredRows;
    private Map<Integer, Filter> filters = null;
    private JTableHeader header;
    private HeaderPopupListener listener;
    private Sorting order = Sorting.NONE;
    private String popup_customize;
    private String popup_empty;
    private String popup_itm_all;
    private String popup_itm_sort_asc;
    private String popup_itm_sort_desc;
    private String popup_text;
    private Set<Integer> sortedOnlyColumn;
    private Integer sortingColumn = -1;
    private TableHeaderPopup tableHeaderPopup;
    private TableModel tableModel;
    private Set<Integer> upToDateColumns;

    public TableFilter(JTable table) {
        this(table.getTableHeader(), table.getModel());
        table.setModel(this);
    }

    public TableFilter(JTableHeader tableHeader, TableModel tableModel2) {
        this.filters = new HashMap<Integer, Filter>();
        this.filteredRows = new ArrayList<Integer>();
        this.disableColumns = new TreeSet<Integer>();
        this.sortedOnlyColumn = new TreeSet<Integer>();
        this.upToDateColumns = new HashSet<Integer>();
        this.filterByColumn = new HashMap<Integer, List<Integer>>();
        this.header = tableHeader;
        tableHeader.getColumnModel().addColumnModelListener(new TableColumnModelAdapter(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TableFilter.this.refreshHeader(TableFilter.this.header.getColumnModel().getColumn(e.getToIndex()).getModelIndex());
            }
        });
        this.setTableValues(tableHeader, tableModel2);
        this.setLocale(TowelConfig.getInstance().getDefaultLocale());
    }

    private void refreshHeader(int column) {
        this.tableHeaderPopup.getPopup(column).removeAllElements();
        if (!this.disableColumns.contains(column)) {
            this.tableHeaderPopup.getPopup(column).addElement(0, null);
        }
    }

    public void setColumnFilterEnabled(Integer column, boolean enabled) {
        if (!enabled) {
            this.disableColumns.add(column);
        } else {
            this.disableColumns.remove(column);
        }
        this.refreshHeader(column);
        this.updateFilter();
    }

    public void setColumnSortedOnly(Integer column, boolean onlySorted) {
        if (onlySorted) {
            this.sortedOnlyColumn.add(column);
        } else {
            this.sortedOnlyColumn.remove(column);
        }
        this.updateFilter();
    }

    public Set<Object> getFilterOptions(int columnIndex) {
        TreeSet<Object> set = new TreeSet<Object>(this.getColumnComparator(columnIndex));
        if (!this.isFiltering()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                set.add(this.getValueAt(i, columnIndex));
            }
        } else {
            ArrayList<Integer> itens = new ArrayList<Integer>();
            this.processFilter(itens, columnIndex);
            for (Integer num : itens) {
                set.add(this.tableModel.getValueAt(num, columnIndex));
            }
        }
        return set;
    }

    public void setFilter(int columnIndex, Filter filter) {
        this.filters.put(columnIndex, filter);
        this.tableHeaderPopup.setModified(columnIndex, true);
        this.updateFilter();
    }

    public String getFilterString(int columnIndex) {
        if (this.filters.containsKey(columnIndex)) {
            return this.filters.get(columnIndex).toString();
        }
        return null;
    }

    public Filter getFilter(int columnIndex) {
        return this.filters.get(columnIndex);
    }

    public void setFilterByString(int columnIndex, String filter) {
        this.setFilter(columnIndex, new StringFilter(filter));
    }

    public void setFilterByRegex(int columnIndex, String filter) {
        this.setFilter(columnIndex, new RegexFilter(filter));
    }

    public void removeFilter(int columnIndex) {
        this.filters.remove(columnIndex);
        this.updateFilter();
    }

    private void updateFilter() {
        this.updateFilter(true);
    }

    private void updateFilter(boolean fireDataChanged) {
        this.generateColumnsIndices();
        this.processFilter();
        this.sortColumn();
        this.upToDateColumns.clear();
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
    }

    private void generateColumnsIndices() {
        this.filterByColumn.clear();
        for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
            ArrayList<Integer> columnFilter = new ArrayList<Integer>();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                columnFilter.add(i);
            }
            this.filterByColumn.put(column, columnFilter);
            if (this.filters.get(column) == null) continue;
            Iterator it = columnFilter.iterator();
            while (it.hasNext()) {
                if (this.filters.get(column).doFilter(this.tableModel.getValueAt((Integer)it.next(), column))) continue;
                it.remove();
            }
        }
    }

    private void processFilter() {
        if (this.isFiltering()) {
            this.processFilter(this.filteredRows, -1);
        }
    }

    private void processFilter(List<Integer> filter, int except) {
        filter.clear();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            filter.add(i);
        }
        for (int i2 = 0; i2 < this.filterByColumn.size(); ++i2) {
            if (i2 == except) continue;
            filter.retainAll((Collection)this.filterByColumn.get(i2));
        }
    }

    private void sortColumn() {
        if (this.isSorting()) {
            Collections.sort(this.filteredRows, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    Object obj1 = TableFilter.this.tableModel.getValueAt(o1, TableFilter.this.sortingColumn);
                    Object obj2 = TableFilter.this.tableModel.getValueAt(o2, TableFilter.this.sortingColumn);
                    if (TableFilter.this.order == Sorting.ASCENDING) {
                        return TableFilter.this.getColumnComparator(TableFilter.this.sortingColumn).compare(obj1, obj2);
                    }
                    return TableFilter.this.getColumnComparator(TableFilter.this.sortingColumn).compare(obj2, obj1);
                }
            });
        }
    }

    private Comparator<Object> getColumnComparator(Integer column) {
        if (Comparable.class.isAssignableFrom(this.tableModel.getColumnClass(column))) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private void updateColumnPopup(int column) {
        if (!this.upToDateColumns.contains(column)) {
            this.upToDateColumns.add(column);
            this.tableHeaderPopup.getPopup(column).removeAllElements();
            if (!this.disableColumns.contains(column)) {
                this.tableHeaderPopup.getPopup(column).addElement(this.popup_itm_sort_asc, this.getHeaderPopupListener());
                this.tableHeaderPopup.getPopup(column).addElement(this.popup_itm_sort_desc, this.getHeaderPopupListener());
                this.tableHeaderPopup.getPopup(column).addElement(this.popup_customize, this.getHeaderPopupListener());
                this.tableHeaderPopup.getPopup(column).addElement(this.popup_empty, this.getHeaderPopupListener());
                this.tableHeaderPopup.getPopup(column).addListSeparator();
                this.tableHeaderPopup.getPopup(column).addElement(this.popup_itm_all, this.getHeaderPopupListener());
                if (!this.sortedOnlyColumn.contains(column)) {
                    for (Object obj : this.getFilterOptions(column)) {
                        this.tableHeaderPopup.getPopup(column).addElement(obj, this.getHeaderPopupListener());
                    }
                }
            }
        }
    }

    public void setSorting(int index, Sorting order2) {
        if (order2 != Sorting.NONE) {
            if (this.sortingColumn != -1 && !this.filters.containsKey(this.sortingColumn)) {
                this.tableHeaderPopup.setModified(this.sortingColumn, false);
            }
            this.sortingColumn = index;
            this.order = order2;
            this.tableHeaderPopup.setModified(index, true);
            this.updateFilter();
        } else if (this.sortingColumn == index) {
            this.sortingColumn = -1;
            this.order = Sorting.NONE;
        }
    }

    private HeaderPopupListener getHeaderPopupListener() {
        if (this.listener == null) {
            this.listener = e -> {
                if (e.getSource().equals(this.popup_itm_sort_asc)) {
                    this.setSorting(e.getModelIndex(), Sorting.ASCENDING);
                } else if (e.getSource().equals(this.popup_itm_sort_desc)) {
                    this.setSorting(e.getModelIndex(), Sorting.DESCENDING);
                } else if (e.getSource().equals(this.popup_itm_all)) {
                    this.setSorting(e.getModelIndex(), Sorting.NONE);
                    this.removeFilter(e.getModelIndex());
                    this.tableHeaderPopup.setModified(e.getModelIndex(), false);
                } else if (e.getSource().equals(this.popup_customize)) {
                    String value;
                    String text = "";
                    if (this.filters.get(e.getModelIndex()) instanceof RegexFilter) {
                        text = ((RegexFilter)this.filters.get(e.getModelIndex())).getRegex();
                    }
                    if ((value = TableFilterWildCard.getValue(this.popup_text, text)) != null) {
                        this.setFilterByRegex(e.getModelIndex(), value);
                    }
                } else if (e.getSource().equals(this.popup_empty)) {
                    this.setFilterByString(e.getModelIndex(), "");
                } else {
                    this.setFilterByString(e.getModelIndex(), e.getSource().toString());
                }
            };
        }
        return this.listener;
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        if (this.isFiltering()) {
            return this.filteredRows.size();
        }
        return this.tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(this.getModelRow(rowIndex), columnIndex);
    }

    private void setTableValues(JTableHeader header2, TableModel tableModel2) {
        this.tableModel = tableModel2;
        this.tableHeaderPopup = new TableHeaderPopup(header2, tableModel2);
        this.tableHeaderPopup.addButtonListener(e -> this.updateColumnPopup(e.getModelIndex()));
        tableModel2.addTableModelListener(this::onTableChanged);
        this.updateFilter();
    }

    private void onTableChanged(TableModelEvent e) {
        if (e.getType() == 1) {
            int first = this.filteredRows.size();
            int last = this.filteredRows.size();
            for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                this.filteredRows.add(row);
                ++last;
            }
            this.fireTableRowsInserted(first, last - 1);
            this.upToDateColumns.clear();
        } else if (e.getType() == -1) {
            if (!this.isFiltering()) {
                this.fireTableRowsDeleted(e.getFirstRow(), e.getLastRow());
                this.upToDateColumns.clear();
                return;
            }
            for (int row = e.getLastRow(); row >= e.getFirstRow(); --row) {
                int index = this.filteredRows.indexOf(row);
                if (index == -1) continue;
                this.filteredRows.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
            int nRemoved = e.getLastRow() - e.getFirstRow() + 1;
            for (int i = 0; i < this.filteredRows.size(); ++i) {
                if (this.filteredRows.get(i) <= e.getLastRow()) continue;
                this.filteredRows.set(i, this.filteredRows.get(i) - nRemoved);
            }
            this.upToDateColumns.clear();
        } else if (e.getType() == 0) {
            if (e.getColumn() == -1) {
                if (!this.isFiltering()) {
                    this.fireTableDataChanged();
                    this.upToDateColumns.clear();
                    return;
                }
                if (e.getLastRow() == Integer.MAX_VALUE) {
                    Integer currentSortingColumn = this.sortingColumn;
                    Sorting currentOrder = this.order;
                    HashMap<Integer, Filter> currentFilters = new HashMap<Integer, Filter>(this.filters);
                    this.sortingColumn = -1;
                    this.order = Sorting.NONE;
                    this.filters.clear();
                    this.updateFilter(false);
                    this.sortingColumn = currentSortingColumn;
                    this.order = currentOrder;
                    this.filters.putAll(currentFilters);
                    this.updateFilter();
                    return;
                }
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    int index = this.filteredRows.indexOf(row);
                    if (index == -1) continue;
                    this.fireTableRowsUpdated(index, index);
                }
                this.upToDateColumns.clear();
            } else {
                this.fireTableCellUpdated(e.getFirstRow(), e.getColumn());
                this.upToDateColumns.remove(e.getColumn());
            }
        }
    }

    public int getModelRow(int viewRow) {
        if (viewRow == -1) {
            return -1;
        }
        return this.isFiltering() ? this.filteredRows.get(viewRow) : viewRow;
    }

    public int[] getModelRows(int[] viewRows) {
        int[] modelRows = new int[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            modelRows[i] = this.getModelRow(viewRows[i]);
        }
        return modelRows;
    }

    public int getViewRow(int modelRow) {
        if (modelRow == -1) {
            return -1;
        }
        if (!this.isFiltering()) {
            return modelRow;
        }
        for (int i = 0; i < this.filteredRows.size(); ++i) {
            if (modelRow != this.filteredRows.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(this.getModelRow(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableModel.setValueAt(aValue, this.getModelRow(rowIndex), columnIndex);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public List<Integer> getFilteredRows() {
        return Collections.unmodifiableList(this.filteredRows);
    }

    public void setLocale(Locale locale) {
        InputStream is = this.getClass().getResourceAsStream("/res/strings_" + locale.toString() + ".properties");
        Properties props = new Properties();
        try {
            props.load(is);
            is.close();
            this.setOptions(props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setOptions(Properties props) {
        this.popup_itm_sort_desc = props.getProperty(POPUP_ITM_SORT_DESC_ATTR);
        this.popup_itm_sort_asc = props.getProperty(POPUP_ITM_SORT_ASC_ATTR);
        this.popup_customize = props.getProperty(POPUP_CUSTOMIZE_ATTR);
        this.popup_empty = props.getProperty(POPUP_EMPTY_ATTR);
        this.popup_itm_all = props.getProperty(POPUP_ITM_ALL_ATTR);
        this.popup_text = props.getProperty(POPUP_TEXT_ATTR);
    }

    public boolean isFiltering() {
        return !this.filters.isEmpty() || this.isSorting();
    }

    public boolean isSorting() {
        return this.sortingColumn != -1 && this.order != Sorting.NONE;
    }

    public Sorting getOrder() {
        return this.order;
    }

    public Integer getSortingColumn() {
        return this.sortingColumn;
    }

    public static class RegexFilter
    implements Filter {
        private String regex = "";

        public RegexFilter() {
        }

        public RegexFilter(String regex2) {
            this.regex = regex2;
        }

        @Override
        public boolean doFilter(Object obj) {
            return Pattern.matches(TextUtils.generateEscapeRegex(this.regex.toLowerCase()).replaceAll("\\\\\\*", ".*").replaceAll("\\\\\\?", "."), obj == null ? "" : obj.toString().toLowerCase());
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex2) {
            this.regex = regex2;
        }
    }

    public static class StringFilter
    implements Filter {
        private String string = "";

        public StringFilter() {
        }

        public StringFilter(String str) {
            this.string = str;
        }

        @Override
        public boolean doFilter(Object obj) {
            return this.string.equals(obj == null ? "" : obj.toString());
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string2) {
            this.string = string2;
        }
    }

    public static enum Sorting {
        NONE,
        ASCENDING,
        DESCENDING;

    }

    public static interface Filter {
        public boolean doFilter(Object var1);
    }
}

