/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.table.adapter;

import com.towel.swing.table.adapter.AbstractColumn;
import com.towel.swing.table.adapter.Column;
import com.towel.swing.table.adapter.EditableColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ColumnTableModel<T>
extends AbstractTableModel {
    private List<Column<T>> columns;
    private boolean isReadOnly = false;
    private List<T> values;

    public static <K, V> ColumnTableModel<Map.Entry<K, V>> createMapModel(Map<K, V> map, String keyHeader, String valueHeader) {
        AbstractColumn keyColumn = new AbstractColumn<Map.Entry<K, V>>(keyHeader, 1){

            @Override
            public Object getValue(Map.Entry<K, V> element) {
                return element.getKey();
            }
        };
        AbstractColumn valueColumn = new AbstractColumn<Map.Entry<K, V>>(valueHeader, 1){

            @Override
            public Object getValue(Map.Entry<K, V> element) {
                return element.getValue();
            }
        };
        return new ColumnTableModel<Map.Entry<K, V>>(map.entrySet(), keyColumn, valueColumn);
    }

    public static void applyToTable(JTable table, List<? extends Column<?>> columns2) {
        int i = 0;
        for (Column<?> c : columns2) {
            EditableColumn ec;
            int i2 = i + 1;
            TableColumn col = new TableColumn(i, c.getWidth());
            col.setHeaderValue(c.getName());
            if (c.getRenderer() != null) {
                col.setCellRenderer(c.getRenderer());
            }
            if (c instanceof EditableColumn && (ec = (EditableColumn)c).getEditor() != null) {
                col.setCellEditor(ec.getEditor());
            }
            table.addColumn(col);
            i = i2;
        }
    }

    public static void applyToTable(JTable table, Column<?> ... columnArr) {
        ColumnTableModel.applyToTable(table, Arrays.asList(columnArr));
    }

    public ColumnTableModel(Collection<T> values2, List<? extends Column<T>> columns2) {
        if (columns2 == null) {
            throw new IllegalArgumentException("Columns cannot be null!");
        }
        if (columns2.size() == 0) {
            throw new IllegalArgumentException("You must provide at least one column!");
        }
        if (values2 == null) {
            throw new IllegalArgumentException("Values can't be null!");
        }
        this.columns = new ArrayList<Column<T>>(columns2);
        this.values = new ArrayList<T>(values2);
    }

    public ColumnTableModel(Collection<T> values2, Column<T> ... columnArr) {
        this(values2, Arrays.asList(columnArr));
    }

    public ColumnTableModel(Column<T> ... columnArr) {
        this(new ArrayList(), Arrays.asList(columnArr));
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).getValue(this.values.get(rowIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getColumnClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.isReadOnly && this.columns.get(columnIndex) instanceof EditableColumn && ((EditableColumn)this.columns.get(columnIndex)).isEditable(this.values.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue != this.getValueAt(rowIndex, columnIndex)) {
            ((EditableColumn)this.columns.get(columnIndex)).setValue(this.values.get(rowIndex), aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public List<T> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public List<Column<T>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void clear() {
        this.values.clear();
        this.fireTableDataChanged();
    }

    public void add(T element) {
        this.values.add(element);
        this.fireTableRowsInserted(this.values.size() - 1, this.values.size() - 1);
    }

    public void addAll(T ... tArr) {
        this.addAll((Collection<? extends T>)Arrays.asList(tArr));
    }

    public void addAll(Collection<? extends T> elements) {
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean remove(T element) {
        int index = this.values.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public T remove(int row) {
        T value = this.values.remove(row);
        this.fireTableRowsDeleted(row, row);
        return value;
    }

    public List<T> removeAll(int ... indices) {
        for (int index : indices) {
            if (index >= 0 && index <= this.values.size()) continue;
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds");
        }
        TreeSet<Integer> indexes = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        for (int index2 : indices) {
            indexes.add(index2);
        }
        ArrayList<T> elements = new ArrayList<T>();
        for (Integer index3 : indexes) {
            elements.add(0, this.remove(index3));
        }
        return elements;
    }

    public int getSize() {
        return this.values.size();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly2) {
        this.isReadOnly = isReadOnly2;
    }

    public int indexOf(T element) {
        return this.values.indexOf(element);
    }

    public T get(int row) {
        return this.values.get(row);
    }

    public void replace(int row, T element) {
        this.values.set(row, element);
        this.fireTableRowsUpdated(row, row);
    }

    public void replaceAll(List<? extends T> elements) {
        this.clear();
        this.addAll((Collection<? extends T>)elements);
    }

    public boolean contains(T element) {
        return this.values.contains(element);
    }

    public void fireChanged(T element) {
        int indexOf = this.values.indexOf(element);
        if (indexOf != -1) {
            this.fireTableRowsUpdated(indexOf, indexOf);
        }
    }

    public void add(int index, T element) {
        this.values.add(index, element);
        this.fireTableRowsInserted(index, index);
    }
}

