/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.table.headerpopup;

import com.towel.swing.table.headerpopup.HeaderButtonListener;
import com.towel.swing.table.headerpopup.HeaderPopup;
import com.towel.swing.table.headerpopup.HeaderPopupEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableHeaderPopup {
    protected EventListenerList listenerList = new EventListenerList();
    private JTableHeader header = null;
    protected List<HeaderPopup> popups = null;
    private TableModel model = null;
    private int selected = -1;
    private Map<Integer, Boolean> modified;

    public TableHeaderPopup(JTableHeader header, TableModel model) {
        this.header = header;
        this.model = model;
        this.modified = new HashMap<Integer, Boolean>();
        this.createPopups();
        this.modifyHeader();
    }

    private void createPopups() {
        this.popups = new ArrayList<HeaderPopup>();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            HeaderPopup headerPopup = new HeaderPopup(this.header, i);
            headerPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    TableHeaderPopup.this.selected = -1;
                    TableHeaderPopup.this.header.invalidate();
                    TableHeaderPopup.this.header.repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    TableHeaderPopup.this.selected = -1;
                    TableHeaderPopup.this.header.invalidate();
                    TableHeaderPopup.this.header.repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    TableHeaderPopup.this.header.invalidate();
                    TableHeaderPopup.this.header.repaint();
                }
            });
            this.popups.add(headerPopup);
        }
    }

    public void modifyHeader() {
        if (this.header.getDefaultRenderer() instanceof FilteredHeaderRenderer) {
            this.header.setDefaultRenderer(new FilteredHeaderRenderer(((FilteredHeaderRenderer)this.header.getDefaultRenderer()).getRenderer()));
        } else {
            this.header.setDefaultRenderer(new FilteredHeaderRenderer(this.header.getDefaultRenderer()));
        }
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    int columnIndex = TableHeaderPopup.this.header.columnAtPoint(e.getPoint());
                    if (columnIndex == -1) {
                        return;
                    }
                    int modelIndex = TableHeaderPopup.this.header.getColumnModel().getColumn(columnIndex).getModelIndex();
                    if (TableHeaderPopup.this.popups.get(modelIndex).isEmpty()) {
                        return;
                    }
                    Rectangle rect = TableHeaderPopup.this.header.getHeaderRect(columnIndex);
                    rect.x = rect.x + rect.width - 17;
                    rect.width = 16;
                    rect.y = rect.y + rect.height - 17;
                    rect.height = 16;
                    if (!rect.contains(e.getPoint())) {
                        return;
                    }
                    TableHeaderPopup.this.fireHeaderButtonClicked(modelIndex);
                    TableHeaderPopup.this.popups.get(modelIndex).show(columnIndex);
                    TableHeaderPopup.this.selected = columnIndex;
                }
            }
        });
    }

    public HeaderPopup getPopup(int modelIndex) {
        return this.popups.get(modelIndex);
    }

    public void setModified(int modelIndex, boolean value) {
        this.modified.put(modelIndex, value);
    }

    public void addButtonListener(HeaderButtonListener l) {
        this.listenerList.add(HeaderButtonListener.class, l);
    }

    protected void fireHeaderButtonClicked(int modelIndex) {
        Object[] listeners = this.listenerList.getListenerList();
        HeaderPopupEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HeaderButtonListener.class) continue;
            if (e == null) {
                e = new HeaderPopupEvent(this, modelIndex);
            }
            ((HeaderButtonListener)listeners[i + 1]).buttonClicked(e);
        }
    }

    private class FilteredHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;

        public FilteredHeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!(c instanceof JLabel)) {
                return c;
            }
            int modelIndex = TableHeaderPopup.this.header.getColumnModel().getColumn(column).getModelIndex();
            if (TableHeaderPopup.this.popups.get(modelIndex).isEmpty()) {
                return c;
            }
            JLabel label = (JLabel)c;
            label.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.add(c, gridBagConstraints);
            JToggleButton button = new JToggleButton();
            if (TableHeaderPopup.this.modified.get(modelIndex) == null || !((Boolean)TableHeaderPopup.this.modified.get(modelIndex)).booleanValue()) {
                button.setIcon(new ImageIcon(this.getClass().getResource("/res/gui/filter.png")));
            } else {
                button.setIcon(new ImageIcon(this.getClass().getResource("/res/gui/filter_red.png")));
            }
            button.setCursor(new Cursor(12));
            button.setBorder(new EmptyBorder(0, 0, 0, 0));
            button.setContentAreaFilled(false);
            button.setPreferredSize(new Dimension(16, 16));
            button.setMaximumSize(new Dimension(16, 16));
            button.setMinimumSize(new Dimension(16, 16));
            button.setFocusable(false);
            button.setSelected(column == TableHeaderPopup.this.selected);
            panel.add((Component)button, new GridBagConstraints());
            Border border = UIManager.getBorder("TableHeader.cellBorder");
            border.getBorderInsets(null).set(0, 2, 1, 1);
            panel.setBorder(label.getBorder());
            label.setBorder(null);
            return panel;
        }

        public TableCellRenderer getRenderer() {
            return this.renderer;
        }
    }
}

