/*
 * Decompiled with CFR 0.152.
 */
package com.towel.time;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    private static SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");

    public static final boolean isValidDate(String psDt) {
        String a = psDt.trim();
        if (a.length() != 10) {
            return false;
        }
        Integer dia = new Integer(a.substring(0, 2));
        Integer mes = new Integer(a.substring(3, 5));
        Integer ano = new Integer(a.substring(6));
        if (mes > 12) {
            return false;
        }
        if (mes == 2) {
            if (ano % 4 == 0 ? dia > 29 : dia > 28) {
                return false;
            }
        } else {
            if (dia > 31) {
                return false;
            }
            if (dia > 30 && (mes == 4 || mes == 6 || mes == 9 || mes == 11)) {
                return false;
            }
        }
        if (dia > 31) {
            return false;
        }
        try {
            Date dataConv = formatter.parse(a);
            Date dataLimiteInf = formatter.parse("01/01/1900");
            return !dataConv.after(formatter.parse("06/06/2079")) && !dataConv.before(dataLimiteInf);
        }
        catch (Exception e) {
            try {
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    public static final Date parseDate(String dateString, String psFormato) {
        return DateUtils.parseDate(dateString, new SimpleDateFormat(psFormato));
    }

    public static final Date parseDate(String dateString, SimpleDateFormat formatter2) {
        try {
            return formatter2.parse(dateString);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    public static final Date parseDate(String psDt) {
        return DateUtils.parseDate(psDt, formatter);
    }

    public static final String format(Date pDt) {
        return formatter.format(pDt);
    }

    public static final String format(Date pDt, String psFormato) {
        return new SimpleDateFormat(psFormato).format(pDt);
    }

    public static final String textToMMDDYYYY(String pdata) {
        if (pdata.equals("__/__/____") || pdata.equals("")) {
            return "";
        }
        return String.valueOf(pdata.substring(3, 5)) + "/" + pdata.substring(0, 2) + "/" + pdata.substring(6);
    }

    public static long msDate(Date pData) {
        return (pData.getTime() + 2209154400000L) / 1000L / 60L / 60L / 24L;
    }

    public static long msDate(String pData) {
        return (DateUtils.parseDate(pData).getTime() + 2209154400000L) / 1000L / 60L / 60L / 24L;
    }

    public static String getDateTime() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS").format(new Date());
    }

    public static String getDateTimeSegundos() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date());
    }
}

