/*
 * Decompiled with CFR 0.152.
 */
package sandbox;

import com.towel.collections.paginator.ListPaginator;
import com.towel.collections.paginator.Paginator;
import com.towel.el.FieldResolver;
import com.towel.el.annotation.AnnotationResolver;
import com.towel.io.Closable;
import com.towel.swing.ModalWindow;
import com.towel.swing.event.ObjectSelectListener;
import com.towel.swing.event.SelectEvent;
import com.towel.swing.table.ObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class NewSelectTable<T> {
    public static final int LIST = 1;
    public static final int SINGLE = 0;
    private JLabel clmSearch;
    private List<Closable> closableHook;
    private JButton closeButton;
    private boolean closed = false;
    private int colFilterIndex;
    private JPanel content;
    private Paginator<T> data;
    private JTextField filterText;
    private JFrame frame;
    private List<ObjectSelectListener> listeners;
    private ObjectTableModel<T> model;
    private JLabel pageLabel;
    private TableRowSorter<ObjectTableModel<T>> rowSorter;
    private JButton searchButton;
    private JButton selectButton;
    private int selectType;
    private Object selected;
    private JTable table;

    public NewSelectTable(FieldResolver[] cols, List<T> data2) {
        this(cols, new ListPaginator<T>(data2, 25));
    }

    public NewSelectTable(AnnotationResolver resolver, String fields, Paginator<T> paginator) {
        this(resolver.resolve(fields), paginator, 0, 400);
    }

    public NewSelectTable(FieldResolver[] cols, Paginator<T> paginator) {
        this(cols, paginator, 0, 400);
    }

    public NewSelectTable(FieldResolver[] cols, Paginator<T> paginator, int w) {
        this(cols, paginator, 0, w);
    }

    public NewSelectTable(ObjectTableModel<T> model2, Paginator<T> paginator) {
        this.colFilterIndex = 0;
        this.listeners = new ArrayList<ObjectSelectListener>();
        this.model = model2;
        this.data = paginator;
        model2.setData(this.data.nextResult());
        this.table = new JTable(model2);
        this.closableHook = new ArrayList<Closable>();
        this.frame = new JFrame("Select");
        this.content = new JPanel();
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.table);
        pane.setPreferredSize(new Dimension(120, 400));
        pane.setMinimumSize(new Dimension(120, 400));
        this.content.setLayout(new BoxLayout(this.content, 3));
        this.rowSorter = new TableRowSorter<ObjectTableModel<T>>(model2);
        this.table.setRowSorter(this.rowSorter);
        this.table.getTableHeader().addMouseListener(new ColumnListener(this, null));
        this.clmSearch = new JLabel();
        this.clmSearch.setText(String.valueOf(model2.getColumnName(this.colFilterIndex)) + ":");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.clmSearch, "West");
        panel.add((Component)this.getJTextFieldFilter(), "East");
        JPanel buttons = new JPanel();
        buttons.setAlignmentX(0.5f);
        this.selectButton = new JButton("Select");
        this.closeButton = new JButton("Close");
        buttons.add(this.selectButton);
        buttons.add(this.closeButton);
        this.content.add(panel);
        this.content.add(pane);
        this.content.add(this.getResultScrollPane());
        this.content.add(buttons);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    NewSelectTable.this.updateSelectedObject();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NewSelectTable.this.dispose();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewSelectTable.this.dispose();
            }
        });
        this.table.addMouseListener(new SelectionListener(this, null));
    }

    public NewSelectTable(FieldResolver[] cols, Paginator<T> paginator, int selectType2, int width) {
    }

    public JTable getTable() {
        return this.table;
    }

    public void closeOnDispose(Closable close) {
        this.closableHook.add(close);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (Closable closable : this.closableHook) {
                closable.close();
            }
        }
    }

    public void setSelectButtonText(String text) {
        this.selectButton.setText(text);
    }

    public void setSearchButtonText(String text) {
        this.searchButton.setText(text);
    }

    public void setCloseButtonText(String text) {
        this.closeButton.setText(text);
    }

    public void setButtonsText(String search, String select, String close) {
        this.setSelectButtonText(select);
        this.setSearchButtonText(search);
        this.setCloseButtonText(close);
    }

    public void addObjectSelectListener(ObjectSelectListener listener) {
        this.listeners.add(listener);
    }

    public Container getContent() {
        return this.content;
    }

    public void showModal(Component parent) {
        try {
            final JDialog dialog = ModalWindow.createDialog(parent, this.getContent(), "Select");
            this.closeOnDispose(new Closable(){

                @Override
                public void close() {
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showSelectTable() {
        this.showSelectTable("Select");
    }

    public void showSelectTable(String title) {
        this.frame = new JFrame(title);
        this.frame.setContentPane(this.content);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setVisible(true);
        this.closeOnDispose(new Closable(){

            @Override
            public void close() {
                NewSelectTable.this.frame.dispose();
            }
        });
    }

    private void notifyListeners(SelectEvent evt) {
        for (ObjectSelectListener listener : this.listeners) {
            listener.notifyObjectSelected(evt.clone());
        }
    }

    public int getSelectType() {
        return this.selectType;
    }

    public void dispose() {
        this.close();
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    private JTextField getJTextFieldFilter() {
        this.filterText = new JTextField(30);
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewSelectTable.this.filter(NewSelectTable.this.filterText.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewSelectTable.this.filter(NewSelectTable.this.filterText.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewSelectTable.this.filter(NewSelectTable.this.filterText.getText());
            }
        });
        this.searchButton = new JButton("Search");
        this.searchButton.setBackground(null);
        this.filterText.setLayout(new BorderLayout());
        this.filterText.add((Component)this.searchButton, "East");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewSelectTable.this.data.filter(NewSelectTable.this.filterText.getText(), NewSelectTable.this.model.getColumnResolver(NewSelectTable.this.colFilterIndex));
                NewSelectTable.this.firstResult();
            }
        });
        return this.filterText;
    }

    private void filter(String text) {
        this.rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, this.colFilterIndex));
    }

    public JPanel getResultScrollPane() {
        JPanel container = new JPanel();
        this.pageLabel = new JLabel("1/" + (this.data.getMaxPage() + 1));
        JButton first = new JButton("<<");
        JButton previous = new JButton("<");
        JButton next = new JButton(">");
        JButton last = new JButton(">>");
        container.add(first);
        container.add(previous);
        container.add(this.pageLabel);
        container.add(next);
        container.add(last);
        first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSelectTable.this.firstResult();
            }
        });
        previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSelectTable.this.previousResult();
            }
        });
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSelectTable.this.nextResult();
            }
        });
        last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSelectTable.this.lastResult();
            }
        });
        return container;
    }

    private void firstResult() {
        this.data.setCurrentPage(0);
        this.model.setData(this.data.nextResult());
        this.pageLabel.setText("1/" + (this.data.getMaxPage() + 1));
    }

    private void previousResult() {
        if (this.data.getCurrentPage() - 2 >= 0) {
            this.data.setCurrentPage(this.data.getCurrentPage() - 2);
            this.model.setData(this.data.nextResult());
            this.pageLabel.setText(String.valueOf(String.valueOf(this.data.getCurrentPage())) + "/" + (this.data.getMaxPage() + 1));
        }
    }

    private void nextResult() {
        try {
            if (this.data.getCurrentPage() >= this.data.getMaxPage()) {
                this.data.setCurrentPage(this.data.getMaxPage());
            }
            this.model.setData(this.data.nextResult());
            this.pageLabel.setText(String.valueOf(String.valueOf(this.data.getCurrentPage())) + "/" + (this.data.getMaxPage() + 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lastResult() {
        this.data.setCurrentPage(this.data.getMaxPage());
        this.model.setData(this.data.nextResult());
        this.pageLabel.setText(String.valueOf(String.valueOf(this.data.getCurrentPage())) + "/" + (this.data.getMaxPage() + 1));
    }

    public void updateSelectedObject() {
        if (this.rowSorter == null) {
            int objIndex = this.table.getSelectedRows()[0];
            this.selected = this.model.getValue(objIndex);
            this.notifyListeners(new SelectEvent(this, this.model.getValue(objIndex)));
        } else if (this.selectType == 0) {
            int objIndex2 = this.rowSorter.convertRowIndexToModel(this.table.getSelectedRows()[0]);
            this.selected = this.model.getValue(objIndex2);
            this.notifyListeners(new SelectEvent(this, this.model.getValue(objIndex2)));
        } else {
            int[] ids = this.table.getSelectedRows();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = this.rowSorter.convertRowIndexToModel(ids[i]);
            }
            this.selected = this.model.getList(ids);
            this.notifyListeners(new SelectEvent(this, this.model.getList(ids)));
        }
        this.dispose();
    }

    public void notifyDataChanged() {
        this.model.fireTableDataChanged();
    }

    public Object getSelectedObject() {
        return this.selected;
    }

    public TableModel getModel() {
        return this.model;
    }

    private class SelectionListener
    extends MouseAdapter {
        private SelectionListener() {
        }

        SelectionListener(NewSelectTable newSelectTable2, SelectionListener selectionListener) {
            this();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                NewSelectTable.this.updateSelectedObject();
                NewSelectTable.this.dispose();
            }
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private ColumnListener() {
        }

        ColumnListener(NewSelectTable newSelectTable2, ColumnListener columnListener) {
            this();
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            NewSelectTable.this.colFilterIndex = NewSelectTable.this.table.columnAtPoint(arg0.getPoint());
            NewSelectTable.this.clmSearch.setText(String.valueOf(NewSelectTable.this.model.getColumnName(NewSelectTable.this.colFilterIndex)) + ":");
            NewSelectTable.this.filterText.setText("");
        }
    }
}

