/*
 * Decompiled with CFR 0.152.
 */
package sandbox.validator;

import java.util.HashMap;
import java.util.Map;
import sandbox.validator.Condition;
import sandbox.validator.EqualsCondition;
import sandbox.validator.NotEqualsCondition;

public class ConditionFactory {
    private Map<String, Class<? extends Condition>> map = new HashMap<String, Class<? extends Condition>>();

    public ConditionFactory() {
        this.register(new EqualsCondition(""));
        this.register(new NotEqualsCondition(""));
    }

    public void register(Condition cond) {
        this.map.put(cond.getSyntax(), cond.getClass());
    }

    public Condition create(String cond, Object value) {
        try {
            return this.map.get(cond).getConstructor(Object.class).newInstance(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

